package request

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
)

type DetailAlertList struct {
	Id int `json:"id" form:"id" binding:"required"`
}

type UpdateAlertList struct {
	RiskLevel int    `json:"risk_level" form:"risk_level" binding:"omitempty,oneof=1 2 3 4"` // 风险等级，1:低风险，2:一般风险，3:较大风险，4:重大风险
	Status    int    `json:"status" form:"status" binding:"omitempty,oneof=1 2 3"`           // 状态，1:已恢复 2:未恢复 3:已关闭
	Keyword   string `json:"keyword" form:"keyword"`                                         // 预警点/分类/指标
}

type BatchPushAlertList struct {
	Id               string                    `json:"id" form:"id"`
	Ids              []string                  `json:"ids" form:"ids" binding:"required_without=Id"`                               // 预警ids
	NotifyMethod     []string                  `json:"notify_method" form:"notify_method" binding:"max=2,dive,oneof=dingtalk sms"` // 预警通知方式 dingtalk sms
	NotifyRecipients []entity.NotifyRecipients `json:"notify_recipients" form:"notify_recipients" binding:"dive"`                  // 预警推送用户
}

type BatchCloseAlertList struct {
	Id          string   `json:"id" form:"id"`
	Ids         []string `json:"ids" form:"ids" binding:"required_without=Id"`               // 预警ids
	CloseRemark string   `json:"close_remark" form:"close_remark" binding:"required"`        // 关闭备注
	DeferPush   int      `json:"defer_push" form:"defer_push" binding:"omitempty,oneof=0 1"` // 延迟三天推送: 0:否 1:是 三天内将不再自动推送该告警信息给处置人员，可手动推送，但告警数据依然会出现
}

type ListAlertList struct {
	Id        int    `json:"id" form:"id"`
	RiskLevel int    `json:"risk_level" form:"risk_level" binding:"omitempty,oneof=1 2 3 4"` // 风险等级，1:低风险，2:一般风险，3:较大风险，4:重大风险
	Status    int    `json:"status" form:"status" binding:"omitempty,oneof=1 2 3"`           // 状态，1:已恢复 2:未恢复 3:已关闭
	Keyword   string `json:"keyword" form:"keyword"`                                         // 预警点/分类/指标
	StartTime string `json:"start_time" form:"start_time" binding:"omitempty,datetime=2006-01-02 15:04:05"`
	EndTime   string `json:"end_time" form:"end_time" binding:"omitempty,datetime=2006-01-02 15:04:05"`
}

type DisposeAlertList struct {
	Id              int    `json:"id" form:"id" binding:"required"`
	Status          int    `json:"status" form:"status" binding:"oneof=1 2"` // 状态，1:已恢复 2:未恢复 3:已关闭
	DisposalContent string `json:"disposal_content" binding:"required"`      // 处置内容(工单管理,结果反馈)
}
