package response

import "gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"

type AlertRulesItem struct {
	entity.AlertRules `xorm:"extends"`
	Expr              string                    `json:"expr" form:"expr"`                       // 指标表达式(PromQL语句)
	AlertRuleType     string                    `json:"alert_rule_type" xorm:"alert_rule_type"` // 预警规则类型 关联字典表
	ClassParentName   string                    `json:"class_parent_name" xorm:"class_parent_name"`
	ClassName         string                    `json:"class_name" xorm:"class_name"`
	MetricConfigName  string                    `json:"metric_config_name" xorm:"metric_config_name"`
	AlertCondition    []entity.AlertCondition   `json:"alert_condition" xorm:"alert_condition"`
	AlertRange        []entity.RulesAlertRange  `json:"alert_range" xorm:"alert_range"`
	NotifyMethod      []string                  `json:"notify_method" xorm:"notify_method"`
	NotifyRecipients  []entity.NotifyRecipients `json:"notify_recipients" xorm:"notify_recipients"`
}

func (a *AlertRulesItem) TableName() string {
	return "alert_rules"
}

type AlertRulesList struct {
	TotalCount int64            `json:"total_count"`
	List       []AlertRulesItem `json:"list"`
}
