package response

import "gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"

type DictListRes struct {
	Id          string         `json:"id" column:"id"`               //主键ID
	Class       int            `json:"class" column:"class"`         //组件分类(1开发语言与版本  2中间件类型与中间件  3云组件类型  4模块类型  5所属区域  6操作系统  7对象类型  8SQL类型  9调研评估结果  10任务阶段  11测试文档类型  12验收问题类型  13Q&A问题类型 14文档类型)
	Name        string         `json:"name" column:"name"`           //组件名称
	ParentId    string         `json:"parent_id" column:"parent_id"` //父id
	Status      int            `json:"status"`
	Description string         `json:"description"`
	UpdatedAt   jsontime.Time  `json:"updated_at"`
	MinVal      string         `json:"min_val" ` //最大值
	MaxVal      string         `json:"max_val"`
	Unit        string         `json:"unit"`
	Sort        int            `json:"sort"`
	BuiltIn     int            `json:"built_in"`
	Children    []*DictListRes `json:"children,omitempty"`
}

//type ComponentDictTreeRes struct {
//	Id       int                     `json:"id" column:"id"`               //主键ID
//	Class    int                     `json:"class" column:"class"`         //组件分类(1开发语言与版本  2中间件类型与中间件  3云组件类型  4模块类型  5所属区域  6操作系统  7对象类型  8SQL类型  9调研评估结果  10任务阶段  11测试文档类型  12验收问题类型  13Q&A问题类型 14文档类型)
//	Name     string                  `json:"name" column:"name"`           //组件名称
//	ParentId int                     `json:"parent_id" column:"parent_id"` //父id
//	Children []*ComponentDictTreeRes `json:"children,omitempty"`
//}
