package response

import "time"

type HostManageRes struct {
	Id          int        `json:"id"`            // id
	HostName    string     `json:"host_name"`     // 主机分组名称
	TaskCnt     int        `json:"task_cnt"`      // 任务数量
	IpCnt       int        `json:"ip_cnt"`        // ip数量
	CreateUser  string     `json:"create_user"`   // 创建人
	CreateTime  time.Time  `json:"create_time"`   // 创建时间
	UpdateUser  string     `json:"update_user"`   // 修改人
	UpdateTime  time.Time  `json:"update_time"`   // 修改时间
	HostFileUrl string     `json:"host_file_url"` // 主机文件url
	HostList    []HostList `json:"host_list"`     // 主机列表
	TaskList    []TaskList `json:"task_list"`     // 任务列表
}

type HostManage struct {
	Id         int       `json:"id"`          // id
	HostName   string    `json:"host_name"`   // 主机分组名称
	CreateUser string    `json:"create_user"` // 创建人
	CreateTime time.Time `json:"create_time"` // 创建时间
	UpdateUser string    `json:"update_user"` // 修改人
	UpdateTime time.Time `json:"update_time"` // 修改时间
}

type HostList struct {
	//Id          int    `json:"id"`           // id
	Ip          string `json:"ip"`           // ip
	Port        string `json:"port"`         // 端口
	VoucherType int    `json:"voucher_type"` // 凭证类型（0密码验证 密钥验证）
	UserName    string `json:"user_name"`    // 用户名
	Password    string `json:"password"`     // 密码
	HostFileUrl string `json:"-"`            // 主机文件url
	Cnt         int    `json:"cnt""`         //主机ip数量
}

type TaskList struct {
	Id       int    `json:"id"`        // id
	TaskName string `json:"task_name"` // 任务名称
	TaskDesc string `json:"task_desc"` // 任务描述
	ExecCnt  int    `json:"exec_cnt"`  // 执行次数
}

type HostManagesRes struct {
	Id         int       `json:"id"`          // id
	HostName   string    `json:"host_name"`   // 主机分组名称
	CreateUser string    `json:"create_user"` // 创建人
	CreateTime time.Time `json:"create_time"` // 创建时间
	TaskCnt    int       `json:"task_cnt"`    // 任务数量
	IpCntErr   int       `json:"ip_cnt_err"`  // ip数量（异常）
	IpCnt      int       `json:"ip_cnt"`      // ip数量(全部)
}

type HostManagesListRes struct {
	Id       int    `json:"id"`        // id
	HostName string `json:"host_name"` // 主机分组名称
}

type HostManageListRes struct {
	Id          int    `json:"id"`           // id
	Ip          string `json:"ip"`           // ip
	Port        string `json:"port"`         // 端口
	VoucherType int    `json:"voucher_type"` // 凭证类型（0密码验证 1密钥验证）
	UserName    string `json:"user_name"`    // 用户名
	Password    string `json:"password"`     // 密码
}

//type HostManageListCacheRes struct {
//	AormalHost   []HostManageListCache `json:"normal_host"`   // 正常ip
//	AbnormalHost []HostManageListCache `json:"abnormal_host"` // 异常ip
//}

type HostManageListCache struct {
	Ip          string `json:"ip"`           // ip
	Port        string `json:"port"`         // 端口
	VoucherType int    `json:"voucher_type"` // 凭证类型（0密码验证 1密钥验证）
	UserName    string `json:"user_name"`    // 用户名
	Password    string `json:"password"`     // 密码
	IpGroup     int    `json:"ip_group"`     // ip分组
}
