package response

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
)

type SystemAccessRule struct {
	Id          int32         `json:"id" xorm:"pk autoincr" `            // id
	RuleId      string        `json:"rule_id"  xorm:"rule_id"`           //规则id
	RuleName    string        `json:"rule_name" xorm:"rule_name"`        // 规则名称
	RuleType    int           `json:"rule_type" xorm:"rule_type"`        // 规则类型
	NumUser     int           `json:"num_user" xorm:"num_user"`          // 用户数量
	RuleDetail  string        `json:"rule_detail" xorm:"rule_detail"`    // 规则描述
	State       int           `json:"state" xorm:"state"`                // 状态0禁用1启用
	CreatedBy   int           `json:"created_by"`                        // 创建者
	CreatedTime jsontime.Time `json:"created_time" xorm:"created_time" ` // 创建时间
	UpdatedBy   int           `json:"updated_by"  `                      // 更新者
	UpdatedTime jsontime.Time `json:"updated_time" xorm:"updated_time" ` // 更新时间
}

type SystemUserAccessRule struct {
	UserId        int    `json:"user_id" xorm:"user_id" `             // 用户id
	SystemAccount string `json:"systemAccount" xorm:"system_account"` // 账号
	//IsAdmin       int    `json:"isAdmin"  xorm:"is_admin"`            //用户类型(1.业务系统账号 2.组织管理员账号 3.平台用户账号 4.超级管理员)
	Phone    string `json:"phone" xorm:"phone"`       // 用户手机号
	Name     string `json:"name" xorm:"name"`         // 所属组织
	Selected string `json:"selected" xorm:"selected"` // 是否已选
}
