package response

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
)

// 系统菜单表
type SystemMenuTree struct {
	Id          int32            `json:"id" xorm:"pk autoincr" `             //id
	Level       int              `json:"level" xorm:"level"`                 //菜单等级
	Sort        int              `json:"sort" xorm:"sort"`                   //菜单排序
	MenuName    string           `json:"menu_name" xorm:"menu_name"`         //菜单名称
	MenuType    int              `json:"menu_type" xorm:"menu_type"`         //菜单类型（0目录1菜单2子页面）
	DictGroupId string           `json:"dict_group_id" xorm:"dict_group_id"` //字典分组id
	State       int              `json:"state" xorm:"state"`                 //状态0禁用1启用
	MenuUrl     string           `json:"menu_url" xorm:"menu_url"`           //菜单路径
	MenuLogo    string           `json:"menu_logo" xorm:"menu_logo"`         //菜单图标
	CreatedTime jsontime.Time    `json:"created_time" xorm:"created"`        //创建时间
	UpdatedTime jsontime.Time    `json:"updated_time" xorm:"updated"`        //更新时间
	CreatedBy   string           `json:"created_by"`                         //创建者
	UpdatedBy   string           `json:"updated_by"`                         //更新者
	MenuId      string           `json:"menu_id" xorm:"menu_id"`             //菜单id
	PMenuId     string           `json:"p_menu_id" xorm:"p_menu_id"`         //上级菜单id
	Source      string           `json:"source" xorm:"source"`               //源
	SystemType  string           `json:"system_type"`                        //系统类型
	NewWindow   int              `json:"new_window"`                         //是否开启新窗口（0 不开 1开启）
	Remark      string           `json:"remark"`                             //备注说明
	BuiltIn     int              `json:"built_in"`                           //是否内置 0 否 1内置数据
	Child       []SystemMenuTree `xorm:"-"`
}

// 系统菜单表
type SystemMenuTreePer struct {
	Id               int32               `json:"id" xorm:"pk autoincr" `             //id
	Level            int                 `json:"level" xorm:"level"`                 //菜单等级
	Sort             int                 `json:"sort" xorm:"sort"`                   //菜单排序
	MenuName         string              `json:"menuName" xorm:"menu_name"`          //菜单名称
	DictGroupId      string              `json:"dict_group_id" xorm:"dict_group_id"` //字典分类id
	MenuType         int                 `json:"menuType" xorm:"menu_type"`          //菜单类型（0目录1菜单2子页面）
	Path             string              `json:"path" xorm:"menu_url"`               //菜单路径
	ParentPath       string              `json:"parentPath" xorm:"-"`
	Icon             string              `json:"icon" xorm:"menu_logo"`      //菜单图标
	MenuId           string              `json:"menu_id" xorm:"menu_id"`     //菜单id
	PMenuId          string              `json:"p_menu_id" xorm:"p_menu_id"` //上级菜单id
	SystemType       string              `json:"system_type"`                //系统类型
	Source           string              `json:"source" xorm:"source"`       //源
	NewWindow        int                 `json:"new_window"`                 //是否开启新窗口（0 不开 1开启）
	Remark           string              `json:"remark"`                     //备注说明
	BuiltIn          int                 `json:"built_in"`                   //是否内置 0 否 1内置数据
	DisplayCondition int                 `json:"-"`                          //展示条件（0 登录 1免登录）
	Children         []SystemMenuTreePer `json:"children" xorm:"-"`
}
