package conf

import (
	"go.uber.org/zap"
	"time"
)

var (
	Options     *Config
	Logger      *zap.Logger
	LoggerLevel string
	RunMode     string
)

// 公共配置
type Config struct {
	DbURL          string
	DbDriver       string
	RedisURL       string
	RedisDB        int
	RedisTag       string
	Prefix         string
	LogDirPrefix   string
	LogDirName     string
	LogSaveDays    int
	LogMode        int
	ArgBool        bool
	ArgInt         int
	MinioServer    string
	MinioAccessKey string
	MinioSecretKey string
	MinioBucket    string
	//TempDirPrefix  string
	PrometheusHost           string
	AccessRuleModeKey        string
	LocationUrl              string
	LocationKey              string
	PrivateKeySSH            string
	PublicKeySSH             string
	OrderDingTalkAccessToken string
	OrderDingTalkSecret      string
	SmsAccessKeyId           string
	SmsAccessSecret          string
	SmsTemplateLogin         string
	SmsSignName              string
}

const (
	LockDuration                 = 1 * time.Hour //锁定时间 默认 1小时
	LockErrorNumber              = 3             //错误次数 3次
	WIDTH                        = 240
	HEIGHT                       = 60
	CookieName                   = "bgToken"
	CookieNameLastLogin   string = "lastLogin"
	LocalDateTimeFormat   string = "2006-01-02 15:04:05"
	FinalHeartBeatUnixKey        = "FinalHeartBeatUnix"
)
