package controller

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

// AddAlertClass 新增任务
func AddAlertClass(c *gin.Context) {
	var req request.AddAlertClass
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertClassSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	_, err = svc.Add(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func UpdateAlertClass(c *gin.Context) {
	var req request.UpdateAlertClass
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertClassSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	err = svc.Update(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func MoveAlertClass(c *gin.Context) {
	direction := c.Param("direction")
	req := request.MoveAlertClass{
		Direction: direction,
	}
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}
	svc := service.AlertClassSvc{User: header.GetUser(c)}
	err := svc.Move(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DetailAlertClass(c *gin.Context) {
	var req request.DetailAlertClass
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertClassSvc{User: header.GetUser(c)}
	data, err := svc.GetDataById(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func ListAlertClass(c *gin.Context) {
	var req request.ListAlertClass
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}
	svc := service.AlertClassSvc{User: header.GetUser(c)}
	data, err := svc.List(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func TreeAlertClass(c *gin.Context) {
	var req request.ListAlertClass
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}
	svc := service.AlertClassSvc{User: header.GetUser(c)}
	data, err := svc.Tree(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func DeleteAlertClass(c *gin.Context) {
	var req request.DeleteAlertClass
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}
	var ids []int
	switch len(req.ClassIds) {
	case 0:
		ids = append(ids, req.ClassId)
	default:
		ids = req.ClassIds
	}

	svc := service.AlertClassSvc{User: header.GetUser(c)}
	err := svc.Delete(ids)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}
