package controller

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

// AddAlertRules 新增任务
func AddAlertRules(c *gin.Context) {
	var req request.AddAlertRules
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertRulesSvc{User: header.GetUser(c)}
	err := svc.Add(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func UpdateAlertRules(c *gin.Context) {
	var req request.UpdateAlertRules
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertRulesSvc{User: header.GetUser(c)}

	err := svc.Update(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func UpdateIsEnabledAlertRules(c *gin.Context) {
	var req request.UpdateIsEnabledAlertRules
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertRulesSvc{User: header.GetUser(c)}

	err := svc.UpdateIsEnabled(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DeleteAlertRules(c *gin.Context) {
	var req request.DeleteAlertRules
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	var ids []string
	switch len(req.Ids) {
	case 0:
		ids = append(ids, req.Id)
	default:
		ids = req.Ids
	}

	svc := service.AlertRulesSvc{User: header.GetUser(c)}
	err := svc.Delete(ids)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DetailAlertRules(c *gin.Context) {
	var req request.DetailAlertRules
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertRulesSvc{User: header.GetUser(c)}
	data, err := svc.GetDataById(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func ListAlertRules(c *gin.Context) {
	var req request.ListAlertRules
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.AlertRulesSvc{User: header.GetUser(c)}
	data, err := svc.List(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}
