package controller

import (
	"net/http"
	"time"

	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/util"
)

// 健康检查
func Health(c *gin.Context) {
	SendJsonResponse(c, resp.OK, gin.H{
		"host":       c.Request.Host,
		"header":     c.Request.Header,
		"serverTime": time.Now(),
		"ip":         util.RemoteIp(c.Request),
	})
}

// 发送json响应信息
func SendJsonResponse(c *gin.Context, err error, data interface{}) {
	code, message, data := resp.DecodeErr(err, data)
	c.JSON(http.StatusOK, resp.Resp{
		Code: code,
		Msg:  message,
		Data: data,
	})
	return
}

// 发送json响应信息-分页
func SendJsonPageResponse(c *gin.Context, err error, data interface{}, total int64) {
	code, message, data := resp.DecodeErr(err, data)
	c.JSON(http.StatusOK, resp.BgPageRes{
		Code:  code,
		Msg:   message,
		Data:  data,
		Total: total,
	})
}
