package controller

import (
	"errors"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

type Dict struct{}

// List 组件列表
func (d Dict) List(c *gin.Context) {

	var (
		err error
		req request.DictReq
	)

	if err = c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), "")
		return
	}

	svc := new(service.Dict)
	svc.Ctx = c
	svc.User = header.GetUser(c)
	result, count, err := svc.List(req)
	if err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), "")
		return
	}

	SendJsonPageResponse(c, resp.OK, result, count)
}

// DictTree 字典列表-树结构
func (d Dict) DictTree(c *gin.Context) {

	var (
		err error
		req request.DictTreeReq
	)

	if err = c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), "")
		return
	}

	//user, _ := header.GetUserContext(c)

	svc := new(service.Dict)
	svc.Ctx = c

	componentDictTreeRes, err := svc.DictTree(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), "")
		return
	}

	SendJsonResponse(c, resp.OK, componentDictTreeRes)
}

// Add 新增字典
func (d Dict) Add(c *gin.Context) {

	var (
		err error
		req request.AddDictReq
	)

	if err = c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), "")
		return
	}

	svc := new(service.Dict)
	svc.Ctx = c
	svc.User = header.GetUser(c)

	err = svc.Add(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), "")
		return
	}

	SendJsonResponse(c, resp.OK, nil)
}

// Update 修改字典
func (d Dict) Update(c *gin.Context) {

	var (
		err error
		req request.UpdateDictReq
	)

	if err = c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), "")
		return
	}

	svc := new(service.Dict)
	svc.Ctx = c
	svc.User = header.GetUser(c)

	err = svc.Update(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), "")
		return
	}

	SendJsonResponse(c, resp.OK, nil)
}

// Del 删除字典
func (d Dict) Del(c *gin.Context) {

	var (
		err error
		id  string
	)

	if id = c.Query("id"); id == "" {
		id = c.Param("id")
	}

	if id == "" {
		SendJsonResponse(c, resp.InvalidParam.WithError(errors.New("参数为空或不正确")), "")
		return
	}

	svc := new(service.Dict)
	svc.Ctx = c
	svc.User = header.GetUser(c)

	err = svc.Del(id)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), "")
		return
	}

	SendJsonResponse(c, resp.OK, nil)
}

// List 组件列表
func (d Dict) ClassList(c *gin.Context) {

	var (
		err       error
		className string
	)

	if className = c.Query("class_name"); className == "" {
		className = c.Param("class_name")
	}

	svc := new(service.Dict)
	svc.Ctx = c
	svc.User = header.GetUser(c)
	classList, err := svc.ClassList(className)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), "")
		return
	}

	SendJsonResponse(c, resp.OK, classList)
}

func (d Dict) DictSort(c *gin.Context) {

	var (
		err error
		req []request.DictSortInput
	)

	err = c.ShouldBind(&req)
	if err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), "")
		return
	}

	svc := new(service.Dict)
	svc.Ctx = c
	svc.User = header.GetUser(c)
	err = svc.DictSort(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), "")
		return
	}

	SendJsonResponse(c, resp.OK, "")
}

func (d Dict) UpdateStatus(c *gin.Context) {
	id := c.Query("id")
	status := c.Query("status")
	if id == "" || status == "" {
		SendJsonResponse(c, resp.InvalidParam.WithData("id 或 status 字段不能为空"), "")
		return
	}
	svc := new(service.Dict)
	svc.Ctx = c
	svc.User = header.GetUser(c)
	total, err := svc.UpdateStatus(id, status)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	if total == 0 {
		SendJsonResponse(c, resp.FAIL, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// List 组件列表
//func (d Dict) ManageList(c *gin.Context) {
//
//	var (
//		err error
//		req request.DictManageListReq
//	)
//
//	if err = c.ShouldBind(&req); err != nil {
//		SendJsonResponse(c, resp.InvalidParam.WithError(err), "")
//		return
//	}

//svc := new(service.Dict)
//svc.Ctx = c
////svc.User = &user
//manageList, err := svc.ManageList(req)
//if err != nil {
//	resp.Json(c, resp.FAIL.WithMsg(err.Error()))
//	return
//}
//
//resp.Json(c, resp.OK.WithData(manageList))
//
//	SendJsonResponse(c, resp.OK, nil)
//
//}
