package controller

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
	"net/http"
	"net/http/httputil"
	"net/url"
)

func AddFile(c *gin.Context) {

	docLibSvc := service.DocLibSvc{}
	doc, err := docLibSvc.AddFile(c)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, doc)
}

func DownloadFile(c *gin.Context) {
	var req request.DocLibGetReq
	if err := c.ShouldBindUri(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	docLibSvc := service.DocLibSvc{}
	docUrl, err := docLibSvc.DownloadFile(c, req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	switch req.Opt {
	case "download":
		//c.Redirect(http.StatusMovedPermanently, docUrl.String())
		docUrlParse, _ := url.Parse(docUrl.String())
		proxy := httputil.ReverseProxy{
			Director: func(req *http.Request) {
				req.Header = c.Request.Header
				req.Host = docUrlParse.Host
				req.URL = docUrlParse
			},
		}
		proxy.ServeHTTP(c.Writer, c.Request)
	case "preview":
		c.Redirect(http.StatusMovedPermanently, docUrl.String())
	}
}
