/**
 * @Author: gaoshiyao
 * @Description: example
 * @File:  example
 * @Date: 2021/05/08 13:54
 */

package controller

import (
	"github.com/gin-gonic/gin"
	"github.com/spf13/cast"
	"github.com/thoas/go-funk"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
	"go.uber.org/zap"
)

// 示例
func Example(c *gin.Context) {
	name := c.Query("name")
	var req struct {
		Name string `json:"name" form:"name" binding:"required"`
		request.Pagination
	}

	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), "")
		return
	}

	// 日志示例
	conf.Logger.Sugar().Infof("cast类型转换器:%d", cast.ToInt("123"))
	conf.Logger.Sugar().Infof("funk工具,数组最大值:%d,数组去重:%d", funk.MaxInt([]int{1, 2, 3, 4, 5}), funk.UniqInt([]int{3, 1, 2, 2, 5}))
	conf.Logger.Info("示例信息", zap.String(name, "调用成功"))
	SendJsonResponse(c, resp.OK, name)
}

// 查询数据
func GetExampleList(c *gin.Context) {
	svc := service.Example{}
	ls, err := svc.List()
	if err != nil {
		SendJsonResponse(c, err, "")
		return
	}
	SendJsonResponse(c, resp.OK, ls)
}
