package controller

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

// AddPushRecord 新增任务
func AddPushRecord(c *gin.Context) {
	var req request.AddPushRecord
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.PushRecordSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	_, err = svc.Add(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func UpdatePushRecord(c *gin.Context) {
	var req request.UpdatePushRecord
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.PushRecordSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	err = svc.Update(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DeletePushRecord(c *gin.Context) {
	var req request.DeletePushRecord
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	var ids []string
	switch len(req.Ids) {
	case 0:
		ids = append(ids, req.Id)
	default:
		ids = req.Ids
	}

	svc := service.PushRecordSvc{User: header.GetUser(c)}
	err := svc.Delete(ids)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DetailPushRecord(c *gin.Context) {
	var req request.DetailPushRecord
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.PushRecordSvc{User: header.GetUser(c)}
	data, err := svc.GetDataById(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func ListPushRecord(c *gin.Context) {
	var req request.ListPushRecord
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.PushRecordSvc{User: header.GetUser(c)}
	data, err := svc.List(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}
