package controller

import (
	vd "github.com/bytedance/go-tagexpr/validator"
	"github.com/gin-gonic/gin"
	"github.com/spf13/cast"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

// AddAccessRule 新增访问规则
func AddAccessRule(c *gin.Context) {
	params := request.AddSystemAccessRuleReq{}
	if err := c.ShouldBindJSON(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	if err := vd.Validate(params); err != nil {
		SendJsonResponse(c, err, "")
		return
	}
	user := header.GetUser(c)
	if user.Id == 0 {
		SendJsonResponse(c, resp.LoginFail, "")
		return
	}
	params.CreatedBy = user.Id

	err := service.AddAccessRule(params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// UpdateAccessRule 编辑访问规则
func UpdateAccessRule(c *gin.Context) {
	params := request.UpdateAccessRuleReq{}
	if err := c.ShouldBindJSON(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	if err := vd.Validate(params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), "")
		return
	}
	user := header.GetUser(c)
	if user.Id == 0 {
		SendJsonResponse(c, resp.LoginFail, "")
		return
	}
	params.UpdatedBy = user.Id
	err := service.UpdateAccessRule(params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// DelAccessRule 删除访问规则
func DelAccessRule(c *gin.Context) {
	params := request.DelAccessRuleReq{}
	if err := c.ShouldBindJSON(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	err := service.DelAccessRule(params.RuleId)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// ListAccessRule 访问规则列表
func ListAccessRule(c *gin.Context) {
	params := request.ListAccessRuleReq{}
	// 绑定分页数据
	if err := c.ShouldBindQuery(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	// 分页数据初始化 limit page  Offset
	list, count, err := service.ListAccessRule(&params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonPageResponse(c, err, list, count)
}

// ListRuleUser 查询用户详情列表
func ListRuleUser(c *gin.Context) {
	params := request.ListRuleUserReq{}
	// 绑定分页数据
	if err := c.ShouldBindQuery(&params); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	list, count, err := service.ListRuleUser(&params)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonPageResponse(c, err, list, count)
}

// UpdateState 修改规则状态
func UpdateState(c *gin.Context) {
	var (
		err   error
		id    string
		state string
	)
	id = c.Query("id")
	state = c.Query("state")
	if id == "" || state == "" {
		SendJsonResponse(c, resp.InvalidParam, nil)
		return
	}

	user := header.GetUser(c)
	if user.Id == 0 {
		SendJsonResponse(c, resp.LoginFail, "")
		return
	}
	updatedBy := user.Id
	err = service.UpdateState(cast.ToInt(id), cast.ToInt(state), updatedBy)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}
