package controller

import (
	"errors"
	"github.com/gin-gonic/gin"
	"github.com/spf13/cast"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/util"
)

// AddWorkOrderManage 新增业务工单管理
func AddWorkOrderManage(c *gin.Context) {
	var req request.AddWorkOrderReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{User: header.GetUser(c)}
	err := workOrderManageSvc.AddWorkOrderManage(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// EditWorkOrderManage 编辑业务工单管理
func EditWorkOrderManage(c *gin.Context) {
	var req request.EditWorkOrderReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	//参数校验
	if err := util.ValidateSimple(req, "Id,HostGroupId"); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{User: header.GetUser(c)}
	err := workOrderManageSvc.EditWorkOrderManage(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// StateWorkOrderManage 定时是否启用
func StateWorkOrderManage(c *gin.Context) {
	var req request.StateWorkOrderReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	//参数校验
	if err := util.ValidateSimple(req, "Id,HostGroupId"); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{}
	err := workOrderManageSvc.StateWorkOrderManage(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// DelWorkOrderManage 删除
func DelWorkOrderManage(c *gin.Context) {
	var req request.DelWorkOrderReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	//参数校验
	if err := util.ValidateSimple(req, "Id"); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{}
	err := workOrderManageSvc.DelWorkOrderManage(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// DetailsWorkOrderManage 详情
func DetailsWorkOrderManage(c *gin.Context) {
	var (
		err error
		id  string
	)

	if id = c.Query("id"); id == "" {
		id = c.Param("id")
	}
	if id == "" {
		SendJsonResponse(c, resp.InvalidParam.WithError(errors.New("id为空")), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{}
	data, err := workOrderManageSvc.DetailsWorkOrderManage(cast.ToInt(id))
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

// ListWorkOrderManage 列表
func ListWorkOrderManage(c *gin.Context) {
	var req request.ListWorkOrderManageReq
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{}
	total, list, err := workOrderManageSvc.ListWorkOrderManage(req)
	if err != nil {
		SendJsonPageResponse(c, err, nil, 0)
		return
	}
	SendJsonPageResponse(c, resp.OK, list, total)
}

// PushWorkOrderManage 手动下发
func PushWorkOrderManage(c *gin.Context) {
	var req request.PushWorkOrderReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{User: header.GetUser(c)}
	err := workOrderManageSvc.PushWorkOrderManage(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// CloseWorkOrderIssuance 关闭工单
func CloseWorkOrderIssuance(c *gin.Context) {
	var req request.CloseWorkOrderReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{}
	err := workOrderManageSvc.CloseWorkOrderIssuance(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// ListWorkOrderIssuance 业务工单下发列表
func ListWorkOrderIssuance(c *gin.Context) {
	var req request.ListWorkOrderReq
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{}
	total, list, err := workOrderManageSvc.ListWorkOrderIssuance(req)
	if err != nil {
		SendJsonPageResponse(c, err, nil, 0)
		return
	}
	SendJsonPageResponse(c, resp.OK, list, total)
}

// DetailsWorkOrderIssuance 业务工单下发详情
func DetailsWorkOrderIssuance(c *gin.Context) {
	var (
		err error
		id  string
	)

	if id = c.Query("id"); id == "" {
		id = c.Param("id")
	}
	if id == "" {
		SendJsonResponse(c, resp.InvalidParam.WithError(errors.New("id为空")), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{}
	data, err := workOrderManageSvc.DetailsWorkOrderIssuance(cast.ToInt(id))
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

// FeedbackWorkOrderMe 处置反馈
func FeedbackWorkOrderMe(c *gin.Context) {
	var req request.FeedbackWorkOrderReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{}
	err := workOrderManageSvc.FeedbackWorkOrderMe(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// ListWorkOrderMe 我的业务工单列表
func ListWorkOrderMe(c *gin.Context) {
	var req request.ListWorkOrderReq
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	workOrderManageSvc := service.WorkOrderManageSvc{User: header.GetUser(c)}
	total, list, err := workOrderManageSvc.ListWorkOrderMe(req)
	if err != nil {
		SendJsonPageResponse(c, err, nil, 0)
		return
	}
	SendJsonPageResponse(c, resp.OK, list, total)
}

// WorkOrderPushNoteMsg 我的业务工单列表
func WorkOrderPushNoteMsg(c *gin.Context) {
	phone := c.Query("phone")

	err := service.WorkOrderPushNoteMsg(phone)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}
