package constant

// 用户类型
type UserType = int

const (
	LoginURL      string = "login"       //账号密码登录路由
	PhoneLoginURL string = "phone/login" //手机号登录路由
)

const (
	YWXTZH UserType = iota + 1 // 业务系统账号
	ZZGLY                      // 组织管理员
	PTYH                       // 平台用户
	CJGLY                      // 超级管理员
)

var UserTypeStrMap = map[UserType]string{
	YWXTZH: "业务系统账号",
	ZZGLY:  "组织管理员",
	PTYH:   "平台用户",
	CJGLY:  "超级管理员",
}

// 操作状态
type operateStatus = int

const (
	Success operateStatus = iota + 1
	Fail
)

var OperateStatusStrMap = map[operateStatus]string{
	Success: "成功",
	Fail:    "失败",
}

type HttpMethod = int

const (
	GET = iota + 1
	POST
	HEAD
	PUT
	DELETE
	CONNECT
	OPTIONS
	TRACE
)

var HttpMethodMap = map[string]HttpMethod{
	"GET":     GET,
	"POST":    POST,
	"HEAD":    HEAD,
	"PUT":     PUT,
	"DELETE":  DELETE,
	"CONNECT": CONNECT,
	"OPTIONS": OPTIONS,
	"TRACE":   TRACE,
}

var HttpMethodStrMap = map[HttpMethod]string{
	GET:     "GET",
	POST:    "POST",
	HEAD:    "HEAD",
	PUT:     "PUT",
	DELETE:  "DELETE",
	CONNECT: "CONNECT",
	OPTIONS: "OPTIONS",
	TRACE:   "TRACE",
}

type OpType = string

const (
	Add            = OpType("新增")
	Edit           = OpType("编辑")
	Find           = OpType("查看")
	Delete         = OpType("删除")
	AllDelete      = OpType("批量删除")
	ResetPwd       = OpType("重置密码")
	UpdatePwd      = OpType("修改密码")
	ForceUpdatePwd = OpType("强制修改密码")
	Login          = OpType("登入")
	Logout         = OpType("登出")
	AssignUser     = OpType("分配用户")
	UpMove         = OpType("上移")
	DownMove       = OpType("下移")
	Export         = OpType("导出")
)

var OpTypeMap = map[int]OpType{
	1:  Add,
	2:  Edit,
	3:  Find,
	4:  Delete,
	5:  AllDelete,
	6:  ResetPwd,
	7:  UpdatePwd,
	8:  ForceUpdatePwd,
	9:  Login,
	10: Logout,
	11: AssignUser,
	12: UpMove,
	13: DownMove,
	14: Export,
}

var OpTypeIntMap = map[OpType]int{
	Add:            1,
	Edit:           2,
	Find:           3,
	Delete:         4,
	AllDelete:      5,
	ResetPwd:       6,
	UpdatePwd:      7,
	ForceUpdatePwd: 8,
	Login:          9,
	Logout:         10,
	AssignUser:     11,
	UpMove:         12,
	DownMove:       13,
	Export:         14,
}
