package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
)

// InitAlertListRouter 初始化预警列表配置路由
func InitAlertListRouter(e *gin.Engine) {
	group := e.Group(fmt.Sprintf("%s/alert_list", conf.Options.Prefix))
	{
		group.GET("", controller.DetailAlertList)
		group.GET("list", controller.ListAlertList)
		group.PUT("", controller.UpdateAlertList)
		group.PUT("batch/push", controller.BatchPushAlertList)
		group.PUT("batch/close", controller.BatchCloseAlertList)
	}
}
