package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
)

// InitAlertRulesRouter 初始化预警规则配置路由
func InitAlertRulesRouter(e *gin.Engine) {
	group := e.Group(fmt.Sprintf("%s/alert_rules", conf.Options.Prefix))
	{
		group.POST("", controller.AddAlertRules)
		group.PUT("", controller.UpdateAlertRules)
		group.PUT("is_enabled", controller.UpdateIsEnabledAlertRules)
		group.DELETE("", controller.DeleteAlertRules)
		group.GET("", controller.DetailAlertRules)
		group.GET("list", controller.ListAlertRules)
	}
}
