package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
)

// InitAutomatedMaintenRouter 初始化自动化运维路由
func InitAutomatedMaintenRouter(e *gin.Engine) {
	so := e.Group(fmt.Sprintf("%s/automated_mainten", conf.Options.Prefix))
	//任务管理
	task := so.Group("/task_manage", header.SetContext)
	{
		task.POST("/add", controller.AddTaskManage)        // 新增
		task.PUT("/edit", controller.EditTaskManage)       // 编辑
		task.DELETE("/del", controller.DelTaskManage)      // 删除
		task.GET("/details", controller.DetailsTaskManage) // 详情
		task.GET("/list", controller.ListTaskManage)       // 列表
		task.POST("/exec/script", controller.ExecScript)   // 立即执行
	}

	//任务历史
	taskHistory := so.Group("/task_history", header.SetContext)
	{
		taskHistory.GET("/list", controller.TaskHistoryList)        // 任务历史列表
		taskHistory.GET("/task_info_list", controller.TaskInfoList) // 任务历史详情列表
		taskHistory.GET("/task_exec_log", controller.TaskExecLog)   // 任务执行日志
	}

	//主机管理
	host := so.Group("/host_manage", header.SetContext)
	{
		host.POST("/add", controller.AddHostManage)                    // 新增
		host.PUT("/edit", controller.EditHostManage)                   // 编辑
		host.DELETE("/del", controller.DelHostManage)                  // 删除
		host.GET("/details", controller.DetailsHostManage)             // 详情
		host.GET("/page_list", controller.PageListHostManage)          // 列表
		host.POST("/state", controller.StateHostManage)                // 状态检测
		host.GET("/ip_exception_list", controller.HostIpExceptionList) // 主机ip异常列表
		host.GET("/export", controller.ExportIp)                       // 导出ip列表
		host.GET("/list", controller.ListHostManage)                   // 主机分组列表-不分页
	}
}
