package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
)

// InitSystemLoginRouter 初始化登录相关路由
func InitSystemLoginRouter(e *gin.Engine) {
	base := e.Group(fmt.Sprintf("%s/user", conf.Options.Prefix))
	{
		base.POST("/login", controller.UserLoginV2)               // 登录
		base.POST("/logout", controller.UserLogout)               // 登出
		base.GET("/getUserInfo", controller.GetUserInfo)          // 获取用户信息
		base.GET("/getCaptcha", controller.GetCaptcha)            // 获取验证码
		base.GET("/verifyCaptcha", controller.VerifyCaptcha)      // 校验验证码
		base.POST("/sms/verifyCode", controller.GetSmsVerifyCode) // 获取短信验证码(5分钟过期)
		base.POST("/phone/login", controller.UserPhoneLogin)      // 手机号登录
		base.GET("/phoneToAccount", controller.PhoneToAccount)    // 根据手机号获取账户
		base.POST("/forget/pwd/check", controller.ForgetPwdCheck) // 忘记密码校验
		base.POST("/update/pwd", controller.UpdateAccountPwd)     // 忘记密码
	}
}
