package router

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
)

// 加载路由
func Load(r *gin.Engine, middleware ...gin.HandlerFunc) {
	r.Use()
	r.Use(gin.Recovery())
	r.Use(header.NoCache)
	r.Use(header.Options)
	r.Use(header.Secure)
	r.Use(header.CopyResponseBody)
	r.Use(middleware...)

	/*gin.DebugPrintRouteFunc = func(httpMethod, absolutePath, handlerName string, nuHandlers int) {
		conf.Logger.Info("routers", zap.String("endpoint", fmt.Sprintf("%v %v %v %v", httpMethod, absolutePath, handlerName, nuHandlers)))
	}*/

	base := r.Group(conf.Options.Prefix)
	{
		base.GET("/health", controller.Health)               // 健康检查
		base.GET("/example", controller.Example)             // 示例
		base.GET("/example/list", controller.GetExampleList) // 示例获取列表
	}

	base.POST("/add_file", controller.AddFile)                               //文件上传
	base.GET("/download_file/:file_name/:ext/:opt", controller.DownloadFile) //文件下载

	// 初始化自动化运维路由
	InitAutomatedMaintenRouter(r)
	// 初始化登录路由
	InitSystemLoginRouter(r)
	// 初始化组织相关路由
	InitOrganizationRouter(r)
	// 初始化用户相关路由
	InitSystemUserRouter(r)
	// 初始化角色相关路由
	InitSystemRoleRouter(r)
	// 初始化菜单相关路由(r)
	InitSystemMenuRouter(r)
	// 初始化字典相关路由(r)
	initDictRoute(r)
	// 首选项配置相关路由
	InitPreferenceConfigRouter(r)
	// 初始化访问控制管理路由
	InitAccessRuleRouter(r)
	// 初始化日志管理
	InitLogManagementRouter(r)
	// 初始化指标配置路由
	InitMetricConfigRouter(r)
	// 初始化预警规则配置路由
	InitAlertRulesRouter(r)
	// 初始化预警列表配置路由
	InitAlertListRouter(r)
	// 初始化prometheus路由
	InitPrometheusRouter(r)
	// 初始化预警总览配置路由
	InitAlertOverviewRouter(r)
	// 初始化推送记录配置路由
	InitPushRecordRouter(r)
	// 初始化工单管理路由
	InitWorkOrderRouter(r)
}
