/*
 * @Descripttion:
 * @Author: Zhang YaSong
 * @version:
 * @Date: 2022-10-21 18:21:35
 * @LastEditors: Zhang YaSong
 * @LastEditTime: 2022-10-21 18:36:04
 */
package util

import (
	"errors"
	"fmt"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"math/rand"
	"net/http"
	"regexp"
	"strings"
	"time"
	"unsafe"

	"github.com/Luzifer/go-openssl/v4"
	"github.com/google/uuid"
)

var OpenSslManager *openssl.OpenSSL = openssl.New()

func IfDangerCharacter(toMatch string) bool {
	// 正则过滤sql注入的方法
	// 参数 : 要匹配的语句

	//过滤 ‘
	//ORACLE 注解 --  /**/
	//关键字过滤 update ,delete
	str := `(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\b(select|update|and|or|delete|insert|trancate|char|chr|into|substr|ascii|declare|exec|count|master|into|drop|execute)\b)`
	re, err := regexp.Compile(str)
	if err != nil {
		return false
	}
	return re.MatchString(toMatch)
}

func DecryptPwd(pwd string) (str string, err error) {
	passphrase := "swuE9cmCZQwrkYRV"
	dec, err := OpenSslManager.DecryptBytes(passphrase, []byte(pwd), openssl.BytesToKeyMD5)
	return string(dec), err
}

type StrReplaceStruct struct {
	CapitalLetter    int `json:"capital_letter"`
	LowercaseLetters int `json:"lowercase_letters"`
	Number           int `json:"number"`
	OtherString      int `json:"other_string"`
}

// 获取密码强度
func GetPwdLevel(pwd string) (level int, err error) {
	password, err := DecryptPwd(pwd)
	if err != nil {
		return 0, err
	}
	conf.Logger.Info(fmt.Sprintf("解析密码为: %s", password))
	var (
		groupCount int
		arrayGroup []int
	)
	arrayGroup = append(arrayGroup, StrReplaceAllString(password).CapitalLetter, StrReplaceAllString(password).LowercaseLetters, StrReplaceAllString(password).Number, StrReplaceAllString(password).OtherString)
	for _, v := range arrayGroup {
		if v > 0 {
			groupCount += 1
		}
	}
	if groupCount == 0 {
		return 0, errors.New("密码非法！")
	} else if groupCount == 1 {
		level = 1
	} else if groupCount == 2 {
		level = 2
	} else if groupCount >= 3 {
		level = 3
	}
	return level, nil
}

func StrReplaceAllString(s2 string) (strReplace StrReplaceStruct) {
	for i := strReplace.OtherString; i < len(s2); i++ {
		switch {
		case 64 < s2[i] && s2[i] < 91:
			strReplace.CapitalLetter += 1
		case 96 < s2[i] && s2[i] < 123:
			strReplace.LowercaseLetters += 1
		case 47 < s2[i] && s2[i] < 58:
			strReplace.Number += 1
		default:
			strReplace.OtherString += 1
		}
	}
	return strReplace
}

func EncryptPwd(password string) (pwd string, err error) {
	passphrase := "swuE9cmCZQwrkYRV"
	ecs, err := OpenSslManager.EncryptBytes(passphrase, []byte(password), openssl.BytesToKeyMD5)
	return string(ecs), err
}

// GetCookieStr , 获取cookie字符串
func GetCookieStr(req *http.Request) (str string, err error) {
	cookies := req.Cookies()
	for _, v := range cookies {
		str += v.Name + "=" + v.Value + ";"
	}
	return str, nil
}

func GetUUID() string {
	// Creating UUID Version 4
	return uuid.New().String()
}

func SpecialEscape(keyword string) string {
	keyword = strings.Replace(keyword, "\\", "\\\\", -1)
	keyword = strings.Replace(keyword, "$", "\\$", -1)
	keyword = strings.Replace(keyword, "%", "\\%", -1)
	keyword = strings.Replace(keyword, "_", "\\_", -1)
	return keyword
}

func Bytes2Str(b []byte) string {
	return *(*string)(unsafe.Pointer(&b))
}

// 计算日期差(t1>t2)
func SubDays(t1, t2 time.Time) (day int) {
	swap := false
	if t1.Unix() < t2.Unix() {
		t_ := t1
		t1 = t2
		t2 = t_
		swap = true
	}
	day = int(t1.Sub(t2).Hours() / 24)
	// 计算在被24整除外的时间是否存在跨自然日
	if int(t1.Sub(t2).Milliseconds())%86400000 > int(86400000-t2.Unix()%86400000) {
		day += 1
	}
	if swap {
		day = -day
	}
	if day < 0 {
		day = 0
	}
	return
}

// CheckMobile 检验手机号
func CheckMobile(phone string) bool {
	regRuler := "^1[345789]{1}\\d{9}$"
	reg := regexp.MustCompile(regRuler)
	return reg.MatchString(phone)
}

// Rand6 生成一个6位随机数字
func Rand6() string {
	return fmt.Sprintf("%06v", rand.New(rand.NewSource(time.Now().UnixNano())).Int31n(1000000))
}
