/**
 * @Author: gaoshiyao
 * @Description: iputil
 * @File:  iputil
 * @Date: 2021/05/08 13:55
 */

package util

import (
	"net"
	"net/http"
)

// RemoteIp 获取访问Ip
func RemoteIp(req *http.Request) string {
	remoteAddr := req.RemoteAddr
	if ip := req.Header.Get("XRealIP"); ip != "" {
		remoteAddr = ip
	} else if ip = req.Header.Get("XForwardedFor"); ip != "" {
		remoteAddr = ip
	} else {
		remoteAddr, _, _ = net.SplitHostPort(remoteAddr)
	}

	if remoteAddr == "::1" {
		remoteAddr = "127.0.0.1"
	}
	return remoteAddr
}
