package util

import (
	"errors"
	"fmt"
	"github.com/bytedance/go-tagexpr"
	vd "github.com/bytedance/go-tagexpr/validator"
)

// 消息编号
type MsgCode string

const (
	MSG1  MsgCode = ""            // 密码即将失效提醒
	MSG2  MsgCode = ""            // 密码强度较弱提醒
	MSG3  MsgCode = ""            // 密码已失效
	MSG14 MsgCode = "ZNX23040702" // 能力评价申诉
	MSG15 MsgCode = "ZNX23040702" // 应用评价申诉
	MSG16 MsgCode = "ZNX23040703" // 应用评价申诉
	MSG17 MsgCode = "ZNX23040704" // 应用评价申诉
)

type VdField struct {
	V string
	M string
}

// Validate 校验
func Validate(value interface{}, fileds ...VdField) error {
	if len(fileds) == 0 {
		return vd.Validate(value)
	} else {

		vm := tagexpr.New("vd")
		if tagExpr, err := vm.Run(value); err != nil {
			return err
		} else {
			for _, filed := range fileds {
				pass := false
				eval := tagExpr.Eval(filed.V)
				switch eval.(type) {
				case bool:
					pass = eval.(bool)
				case error:
					pass = false
				case nil:
					pass = true
				case string:
					pass = false
				default:
					pass = false
				}
				if !pass {
					return errors.New(tagExpr.EvalString(filed.M))
				}
			}
		}
		return nil
	}
}

// ValidateSimple 简单的校验  不支持嵌套struct
func ValidateSimple(value interface{}, fileds ...string) error {
	var fs []VdField

	if len(fileds) > 0 {
		for _, filed := range fileds {
			fs = append(fs, VdField{
				V: filed,
				M: fmt.Sprintf("%s@msg", filed),
			})
		}
	}
	return Validate(value, fs...)
}
