package entity

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
)

type AlertList struct {
	Id                int            `json:"id"`                                       // 预警列表ID，主键，自增长
	AlertPoint        string         `json:"alert_point"`                              // 预警点
	AlertRulesId      string         `json:"alert_rules_id"`                           // 告警规则id
	RiskLevel         int            `json:"risk_level"`                               // 风险等级，1:低风险，2:一般风险，3:较大风险，4:重大风险
	AlertTime         jsontime.Time  `json:"alert_time"`                               // 预警时间
	ClassId           int            `json:"class_id"`                                 // 预警对象id(级联:预警分类/预警对象)
	ClassParentName   string         `json:"class_parent_name"`                        // 预警分类名称 TODO 该字段做关联存储或查询
	ClassName         string         `json:"class_name"`                               // 预警对象名称 TODO 该字段做关联存储或查询
	MetricConfigId    string         `json:"metric_config_id"`                         // 预警指标id 	// 预警指标
	MetricConfigName  string         `json:"metric_config_name"`                       // 预警指标名称
	AlertRuleType     string         `json:"alert_rule_type"`                          // 预警规则类型id TODO 该字段做关联存储或查询
	AlertRuleTypeName string         `json:"alert_rule_type_name"`                     // 预警规则类型名称 TODO 该字段做关联存储或查询
	CurrentValue      float64        `json:"current_value"`                            // 当前报警值
	AlertCondition    string         `json:"alert_condition" xorm:"'alert_condition'"` // 预警规则(预警阈值) 字典值
	NotificationCount int            `json:"notification_count"`                       // 通知人数
	PushCount         int            `json:"push_count"`                               // 推送次数
	LastPushTime      jsontime.Time  `json:"last_push_time"`                           // 最近推送时间
	Status            int            `json:"status"`                                   // 状态，1:已恢复 2:未恢复 3:已关闭
	DisposedList      []DisposedList `json:"disposed_list"`                            // 处置列表
	CloseRemark       string         `json:"close_remark"`                             // 关闭备注(预警关闭提醒)
	CloseUser         string         `json:"close_user"`                               // 关闭用户,预警关闭提醒
	CloseTime         jsontime.Time  `json:"close_time"`                               // 关闭关闭时间,预警关闭提醒
	DeferPush         int            `json:"defer_push" xorm:"defer_push"`             // 延迟三天推送: 0:否 1:是 三天内将不再自动推送该告警信息给处置人员，可手动推送，但告警数据依然会出现
	CreatedBy         string         `json:"created_by" xorm:"'created_by'"`           // 创建人
	CreatedAt         jsontime.Time  `json:"created_at" xorm:"'created_at'"`           // 创建时间
	UpdatedBy         string         `json:"updated_by" xorm:"'updated_by'"`           // 更新人
	UpdatedAt         jsontime.Time  `json:"updated_at" xorm:"'updated_at'"`           // 更新时间
}

type DisposedList struct {
	IsDisposed      int           `json:"is_disposed"`      // 是否处置(工单管理)，1:已处置，2:未处置
	DisposalContent string        `json:"disposal_content"` // 处置内容(工单管理,结果反馈)
	DisposalUser    string        `json:"disposal_user"`    // 处置人(工单管理,结果反馈)
	DisposalTime    jsontime.Time `json:"disposal_time"`    // 处置时间(工单管理,结果反馈)
}

func (a *AlertList) TableName() string {
	return "alert_list"
}
