package entity

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
)

type AlertOverview struct {
	RiskLevel       int           `json:"risk_level"`                     // 风险等级，1:低风险，2:一般风险，3:较大风险，4:重大风险
	UnresolvedCount int           `json:"unresolved_count"`               // 未恢复数量
	TotalCount      int           `json:"total_count"`                    // 总预警数
	List            []AlertArray  `json:"list"`                           // 预警列表
	CreatedBy       string        `json:"created_by" xorm:"'created_by'"` // 创建人
	CreatedAt       jsontime.Time `json:"created_at" xorm:"'created_at'"` // 创建时间
	UpdatedBy       string        `json:"updated_by" xorm:"'updated_by'"` // 更新人
	UpdatedAt       jsontime.Time `json:"updated_at" xorm:"'updated_at'"` // 更新时间
}

type AlertArray struct {
	MetricName      string `json:"metric_name" xorm:"'metric_name'"` // 预警规则名称(指标名称)
	UnresolvedCount int    `json:"unresolved_count"`                 // 未恢复数量
	TotalCount      int    `json:"total_count"`                      // 总预警数
}

type RiskLevelDistribution struct {
	Name string `json:"name"` // 名称
	//RiskLevel  int    `json:"risk_level"` // 风险等级，1:低风险，2:一般风险，3:较大风险，4:重大风险
	//Percentage string `json:"percentage"` // 百分比
	Value int `json:"value"`
}

type AlertStatusDistribution struct {
	Name string `json:"name"` // 名称
	//Status     int    `json:"status"`     // 状态，1:已恢复 2:未恢复 3:已关闭
	//Percentage string `json:"percentage"` // 百分比
	Value int `json:"value"`
}

type AlertClassDistribution struct {
	Name string `json:"name"` // 名称
	//ClassId    int    `json:"class_id"`   // 预警分类id
	//Percentage string `json:"percentage"` // 百分比
	Value int `json:"value"`
}

type AlertFrequencyDistribution struct {
	//Name  string   `json:"name"`  // 名称
	//Value int      `json:"count"` // 数量
	XAxis []string `json:"xAxis"`
	Data  []int    `json:"data"`
}

func (a *AlertOverview) TableName() string {
	return "alert_overview"
}
