package entity

import "gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"

// AlertRules 预警规则配置
type AlertRules struct {
	Id                  string        `json:"id" xorm:"'id' pk"`                                    // 主键id
	MetricName          string        `json:"metric_name" xorm:"'metric_name'"`                     // 预警规则名称(指标名称)
	DetectionType       int           `json:"detection_type" xorm:"'detection_type'"`               // 检测类型 1:静态阈值 2:自定义
	ClassId             int           `json:"class_id" xorm:"'class_id'"`                           // 预警对象id(级联:预警分类/预警对象)
	MetricConfigId      string        `json:"metric_config_id" xorm:"'metric_config_id'"`           // 预警指标id
	AlertRange          string        `json:"alert_range" xorm:"'alert_range'"`                     // 预警范围 字典值
	AlertCondition      string        `json:"alert_condition" xorm:"'alert_condition'"`             // 预警规则 字典值
	Duration            int           `json:"duration" xorm:"'duration'"`                           // 持续时间
	DurationUnit        string        `json:"duration_unit" xorm:"'duration_unit'"`                 // 持续时间单位 s m h
	CheckPeriod         int           `json:"check_period" xorm:"'check_period'"`                   // 检查周期 单位:分钟
	NotifyMethod        string        `json:"notify_method" xorm:"'notify_method'"`                 // 预警通知方式 dingtalk sms
	NotifyRecipients    string        `json:"notify_recipients" xorm:"notify_recipients"`           // 预警推送用户
	NotifyPushCount     int           `json:"notify_push_count" xorm:"'notify_push_count'"`         // 消息推送次数
	NotifyPushFrequency int           `json:"notify_push_frequency" xorm:"'notify_push_frequency'"` // 消息推送频率 分钟
	IsEnabled           int           `json:"is_enabled" xorm:"'is_enabled'"`                       // 是否开启 1:是 2:否
	CreatedBy           string        `json:"created_by" xorm:"'created_by'"`                       // 创建人
	CreatedAt           jsontime.Time `json:"created_at" xorm:"'created_at'"`                       // 创建时间
	UpdatedBy           string        `json:"updated_by" xorm:"'updated_by'"`                       // 更新人
	UpdatedAt           jsontime.Time `json:"updated_at" xorm:"'updated_at'"`                       // 更新时间
}

func (m *AlertRules) TableName() string {
	return "alert_rules"
}

type RulesAlertRange struct {
	AlertRange
	Value   string `json:"value" form:"value" binding:"required"`
	Compare string `json:"compare" form:"compare" binding:"required,oneof== != =~ !~"`
}

type AlertCondition struct {
	ThresholdsMax int `json:"thresholds_max" form:"thresholds_max" binding:"required"`
	ThresholdsMin int `json:"thresholds_min" form:"thresholds_min" binding:"required"`
	RiskLevel     int `json:"risk_level" form:"risk_level" binding:"required,oneof=1 2 3 4"`
}

type NotifyRecipients struct {
	SystemAccount string `json:"system_account" form:"system_account" binding:"required"`
	UserName      string `json:"user_name"  form:"user_name" binding:"required"`
	Phone         string `json:"phone" form:"phone" binding:"required,phone"`
}
