package entity

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
)

type DictBase struct {
	Id          string        `json:"id" xorm:"pk autoincr" `     //id
	Class       int           `json:"class"`                      //菜单分组id
	Name        string        `json:"name"  `                     //字典名称
	ParentId    int           `json:"parent_id"  `                //父级id
	Status      int32         `json:"status"  `                   //状态 1-启用 2-禁用
	IsDelete    int32         `json:"is_delete"  `                //是否删除 1-是 0-否
	DictType    int32         `json:"dict_type"  `                //字典类型（0-用户 1-系统）
	Description string        `json:"description"  `              //描述
	CreatedBy   int           `json:"created_by"  `               //创建者
	CreatedAt   jsontime.Time `json:"created_at" xorm:"created" ` //创建时间
	UpdatedBy   int           `json:"updated_by"  `               //更新者
	UpdatedAt   jsontime.Time `json:"updated_at" xorm:"updated" ` //更新时间
	MinVal      string        `json:"min_val"`                    //最大值
	MaxVal      string        `json:"max_val"`                    //最小值
	Sort        int64         `json:"sort"  `                     //排序字段 降序排列
}

type Dict struct {
	Id          string        `json:"id" xorm:"id"`                   //主键ID
	Class       int           `json:"class" xorm:"class"`             //组件分类(1开发语言与版本  2中间件类型与中间件  3云组件类型  4模块类型  5所属区域  6操作系统  7对象类型  8SQL类型  9调研评估结果  10任务阶段  11测试文档类型  12验收问题类型  13Q&A问题类型 14文档类型)
	Name        string        `json:"name" xorm:"name"`               //组件名称
	ParentId    string        `json:"parent_id" xorm:"parent_id"`     //父id
	Status      int           `json:"status" xorm:"status"`           //是否启用(0:启用 1:禁用)
	IsDelete    int           `json:"is_delete" xorm:"is_delete"`     //是否删除（0未删除 1已删除）
	DictType    int           `json:"dict_type" xorm:"dict_type"`     //字典类型（0用户 1系统）
	Description string        `json:"description" xorm:"description"` //描述
	CreatedBy   int           `json:"created_by" xorm:"created_by"`   //创建人
	CreatedAt   jsontime.Time `json:"created_time" xorm:"created_at"` //创建时间
	UpdatedBy   int           `json:"updated_by" xorm:"updated_by"`   //修改人
	UpdatedAt   jsontime.Time `json:"updated_time" xorm:"updated_at"` //修改时间
	MinVal      string        `json:"min_val" xorm:"min_val"`         //最大值
	MaxVal      string        `json:"max_val" xorm:"max_val"`         //最小值
	Unit        string        `json:"unit" xorm:"unit"`               //单位
	Sort        int           `json:"sort"  xorm:"sort autoincr"`     //排序字段 降序排列
}

func (c Dict) TableName() string {
	return "dict"
}

type DictClass struct {
	ClassId   int    `json:"class_id" xorm:"class_id"`     //字典类别id
	ClassName string `json:"class_name" xorm:"class_name"` //字典类别名称
}

func (c DictClass) TableName() string {
	return "dict_class"
}
