package entity

import (
	"time"
)

type SystemUser struct {
	Id             int       `json:"id" xorm:"pk autoincr" `                   // id
	Name           string    `json:"name"  `                                   // 名称
	SystemAccount  string    `json:"system_account"  `                         // 账号
	OrganizationId string    `json:"organization_id" xorm:"organization_id"`   // 所属组织
	Password       string    `json:"password"`                                 // 密码
	State          int       `json:"state" xorm:"state"`                       // 状态0禁用1启用
	Logo           string    `json:"logo" xorm:"logo"`                         // 头像logo
	CreatedBy      int       `json:"created_by"  `                             // 创建者
	CreatedTime    time.Time `json:"created_time" xorm:"created" `             // 创建时间
	UpdatedBy      int       `json:"updated_by"  `                             // 更新者
	UpdatedTime    time.Time `json:"updated_time" xorm:"updated" `             // 更新时间
	IsDeleted      int       `json:"is_deleted" xorm:"is_deleted"`             // 是否删除
	Phone          string    `json:"phone" xorm:"phone"`                       // 手机号
	PwdLevel       int       `json:"pwd_level"`                                // 密码强度1低2中3高
	PwdForceStatus int       `json:"pwd_force_status"`                         // 密码强制修改状态0否1是
	LastAccessTime time.Time `json:"last_access_time" xorm:"last_access_time"` // 用户最后访问时间
	PwdUpdatedTime time.Time `json:"pwd_updated_time"`                         // 密码修改时间
}

type SystemUserInfo struct {
	Id             int       `json:"id" xorm:"pk autoincr" `                   // id
	Name           string    `json:"name"  `                                   // 名称
	SystemAccount  string    `json:"system_account"  `                         // 账号
	OrganizationId string    `json:"organization_id" xorm:"organization_id"`   // 所属组织
	Password       string    `json:"password,omitempty"`                       // 密码
	State          int       `json:"state" xorm:"state"`                       // 状态0禁用1启用
	Logo           string    `json:"logo" xorm:"logo"`                         // 头像logo
	IsDeleted      int       `json:"is_deleted" xorm:"is_deleted"`             // 是否删除
	Phone          string    `json:"phone" xorm:"phone"`                       // 手机号
	PwdLevel       int       `json:"pwd_level"`                                // 密码强度1低2中3高
	PwdForceStatus int       `json:"pwd_force_status"`                         // 密码强制修改状态0否1是
	LastAccessTime time.Time `json:"last_access_time" xorm:"last_access_time"` // 用户最后访问时间
	PwdUpdatedTime time.Time `json:"pwd_updated_time"`                         // 密码修改时间
	OrgName        string    `json:"org_name"`                                 // 组织机构名称
}
