package entity

import "time"

type SystemUserBehavior struct {
	Id             int       `json:"id" xorm:"pk autoincr"`       //主键id
	UserId         int       `json:"user_id"`                     //用户id
	OrganizationId string    `json:"organization_id"`             //组织uuid
	SystemModule   string    `json:"system_module"`               //系统模块
	OperateType    string    `json:"operate_type"`                //操作类型
	ReqMethod      int       `json:"req_method"`                  //请求方式
	OperateStatus  int       `json:"operate_status"`              //操作状态
	OperateIp      string    `json:"operate_ip"`                  //操作ip信息
	OperateAddr    string    `json:"operate_addr"`                //操作地点
	CreatedTime    time.Time `json:"created_time" xorm:"created"` //操作时间
	IsDeleted      int       `json:"is_deleted"`                  //是否删除
	OperateMethod  string    `json:"operate_method"`              //操作方法函数名
	ResFields      string    `json:"res_fields"`                  //返回参数
	ReqParam       string    `json:"req_param"`                   //请求参数
	ReqUrl         string    `json:"req_url"`                     //请求地址
	AppId          string    `json:"app_id"`
	Phone          string    `json:"phone" xorm:"-"`
}
