package request

import "gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"

type AddMetricConfig struct {
	ClassId       int                 `json:"class_id" form:"class_id" binding:"required"`                       // 预警对象分类id
	MetricName    string              `json:"metric_name" form:"metric_name" binding:"required"`                 // 指标名称
	Expr          string              `json:"expr" form:"expr" binding:"required"`                               // 指标表达式(PromQL语句)
	AlertRange    []entity.AlertRange `json:"alert_range" form:"alert_range" binding:"required,dive"`            // 预警范围 字典值
	Duration      int                 `json:"duration" form:"duration"`                                          // 持续时间
	DurationUnit  string              `json:"duration_unit" form:"duration_unit" binding:"required,oneof=s m h"` // 持续时间单位 s m h
	CheckPeriod   int                 `json:"check_period" form:"check_period" binding:"oneof=1 3 5 10 20 30"`   // 检查周期 单位:分钟
	IsEnabled     int                 `json:"is_enabled" form:"is_enabled" binding:"omitempty,oneof=1 2"`        // 是否开启 1:是 2:否
	AlertRuleType string              `json:"alert_rule_type" form:"alert_rule_type" binding:"required"`         // 预警规则类型 关联字典表
	SourceFrom    int                 `json:"source_from" form:"source_from" binding:"omitempty,oneof=1 2"`      // 数据来源 1:默认 2:自定义
}

type UpdateMetricConfig struct {
	Id            string              `json:"id" form:"id" binding:"required"`                                           // 主键id
	ClassId       int                 `json:"class_id" form:"class_id"`                                                  // 预警对象分类id
	MetricName    string              `json:"metric_name" form:"metric_name"`                                            // 指标名称
	Expr          string              `json:"expr" form:"expr"`                                                          // 指标表达式(PromQL语句)
	AlertRange    []entity.AlertRange `json:"alert_range" form:"alert_range"`                                            // 预警范围 字典值
	Duration      int                 `json:"duration" form:"duration"`                                                  // 持续时间
	DurationUnit  string              `json:"duration_unit" form:"duration_unit" binding:"omitempty,oneof=s m h"`        // 持续时间单位 s m h
	CheckPeriod   int                 `json:"check_period" form:"check_period" binding:"omitempty,oneof=1 3 5 10 20 30"` // 检查周期 单位:分钟
	IsEnabled     int                 `json:"is_enabled" form:"is_enabled" binding:"omitempty,oneof=1 2"`                // 是否开启 1:是 2:否
	AlertRuleType string              `json:"alert_rule_type" form:"alert_rule_type"`                                    // 预警规则类型 关联字典表
	SourceFrom    int                 `json:"source_from" form:"source_from" binding:"omitempty,oneof=1 2"`              // 数据来源 1:默认 2:自定义
}

type DeleteMetricConfig struct {
	Id  string   `json:"id" form:"id"`
	Ids []string `json:"ids" form:"ids" binding:"required_without=Id"`
}

type DetailMetricConfig struct {
	Id string `json:"id" form:"id" binding:"required"`
}

type ListMetricConfig struct {
	Id         string `json:"id" form:"id"`                                                                  // 主键id
	ClassId    int    `json:"class_id" form:"class_id"`                                                      // 分类id
	MetricName string `json:"metric_name" form:"metric_name"`                                                // 指标名称
	IsEnabled  int    `json:"is_enabled" form:"is_enabled" binding:"omitempty,oneof=1 2"`                    // 是否开启 1:是 2:否
	StartTime  string `json:"start_time" form:"start_time" binding:"omitempty,datetime=2006-01-02 15:04:05"` // 开始时间
	EndTime    string `json:"end_time" form:"end_time" binding:"omitempty,datetime=2006-01-02 15:04:05"`     // 结束时间
	Pagination
}
