package response

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
)

type LogManagementRep struct {
	Id             int32  `json:"id" xorm:"pk autoincr" `                 // id
	OrganizationId string `json:"organization_id" xorm:"organization_id"` // 所属组织
	Name           string `json:"name"`                                   // 所属组织名称
	SystemAccount  string `json:"system_account" xorm:"system_account"`   // 系统账号
	Phone          string `json:"phone" xorm:"phone"`                     // 联系人电话
	//IsAdmin         string            `json:"is_admin" xorm:"is_admin"`               // 用户类型  (1.业务系统账号 2.组织管理员账号 3.平台用户账号 4.超级管理员)
	LastAccessTimes jsontime.Time `json:"-" xorm:"last_access_time"`         // 用户最后访问时间
	LastAccessTime  jsontime.Time `json:"last_access_time" xorm:"-"`         // 用户最后访问时间
	Active          string        `json:"active"`                            // 活跃度 高：小于等于7天，中：大于7天小于一个月，低：大于等于一个月  1: 低 2：中  3： 高
	PwdLevel        string        `json:"pwd_level"`                         // 密码强度  1低2中3高
	PwdIsUsed       int           `json:"pwd_is_used"`                       // 密码使用时长
	CreatedTime     jsontime.Time `json:"created_time" xorm:"created_time" ` // 创建时间
}

type SystemUserBehaviorList struct {
	//Xh             int64         `json:"xh" xorm:"id"`
	Id             int           `json:"id" xorm:"id"`                // 主键id
	UserId         int           `json:"user_id"`                     // 系统用户id
	OrganizationId string        `json:"organization_id"`             // 组织uuid
	SystemModule   string        `json:"system_module"`               // 系统模块
	OperateType    string        `json:"operate_type"`                // 操作类型
	ReqMethod      int           `json:"req_method"`                  // 请求方式
	OperateStatus  int           `json:"operate_status"`              // 操作状态
	OperateIp      string        `json:"operate_ip"`                  // 操作ip信息
	OperateAddr    string        `json:"operate_addr"`                // 操作地点
	CreatedTime    jsontime.Time `json:"created_time" xorm:"created"` // 操作时间
	IsDeleted      int           `json:"is_deleted"`                  // 是否删除
	OperateMethod  string        `json:"operate_method"`              // 操作方法函数名
	ResFields      string        `json:"res_fields"`                  // 返回参数
	ReqParam       string        `json:"req_param"`                   // 请求参数
	ReqUrl         string        `json:"req_url"`                     // 请求地址
	AppId          string        `json:"app_id"`                      // appId
	SystemAccount  string        `json:"system_account"`              // 系统账号
	Phone          string        `json:"-" xorm:"phone"`              // 手机号
	//IsAdmin        int           `json:"is_admin"`                    // 用户类型
	OrgName string `json:"org_name"` // 组织
}

type LogUserBehaviorDetailRep struct {
	Id               int           `json:"id" xorm:"pk autoincr"` // 主键id
	UserId           int           `json:"user_id"`               // 系统用户id
	OrganizationId   string        `json:"organization_id"`       // 组织uuid
	SystemModule     string        `json:"system_module"`         // 系统模块
	OperateType      string        `json:"operate_type"`          // 操作类型
	ReqMethod        int           `json:"req_method"`            // 请求方式
	ReqMethodStr     string        `json:"req_method_str" xorm:"-"`
	OperateStatus    int           `json:"operate_status"` // 操作状态
	OperateStatusStr string        `json:"operate_status_str" xorm:"-"`
	OperateIp        string        `json:"operate_ip"`                  // 操作ip信息
	OperateAddr      string        `json:"operate_addr"`                // 操作地点
	CreatedTime      jsontime.Time `json:"created_time" xorm:"created"` // 操作时间
	OperateMethod    string        `json:"operate_method"`              // 操作方法函数名
	ResFields        string        `json:"res_fields"`                  // 返回参数
	ReqParam         string        `json:"req_param"`                   // 请求参数
	ReqUrl           string        `json:"req_url"`                     // 请求地址
	AppId            string        `json:"app_id"`                      // appId
	SystemAccount    string        `json:"system_account"`              // 系统账号
	Phone            string        `json:"phone"`                       // 手机号
	//IsAdmin          int           `json:"-"`                           // 用户类型
	//UserType         string        `json:"user_type" xorm:"-"`
	OrgName string `json:"org_name"` // 组织
}

type SystemUserBehaviorInfo struct {
	Total map[string]interface{} `json:"total"`
	Hits  []BehaviorSourceData   `json:"hits"`
}

type BehaviorSourceData struct {
	Id     string               `json:"_id"`
	Source SystemUserBehaviorEs `json:"_source"`
}

type SystemUserBehaviorEs struct {
	Id              string `json:"id"`
	Xh              int64  `json:"xh"`
	UserId          int    `json:"user_id"`                     // 系统用户id
	OrganizationId  string `json:"organization_id"`             // 组织uuid
	SystemModule    string `json:"system_module"`               // 系统模块
	OperateType     string `json:"operate_type"`                // 操作类型
	ReqMethod       int    `json:"req_method"`                  // 请求方式
	OperateStatus   int    `json:"operate_status"`              // 操作状态
	OperateIp       string `json:"operate_ip"`                  // 操作ip信息
	OperateAddr     string `json:"operate_addr"`                // 操作地点
	CreatedTime     string `json:"created_time" xorm:"created"` // 操作时间
	CreatedTimeUnix int64  `json:"created_time_unix"`           // 操作时间戳(用于排序统计)
	IsDeleted       int    `json:"is_deleted"`                  // 是否删除
	OperateMethod   string `json:"operate_method"`              // 操作方法函数名
	ResFields       string `json:"res_fields"`                  // 返回参数
	ReqParam        string `json:"req_param"`                   // 请求参数
	ReqUrl          string `json:"req_url"`                     // 请求地址
	AppId           string `json:"app_id"`                      // appId
	SystemAccount   string `json:"system_account"`              // 系统账号
	Phone           string `json:"phone" xorm:"phone"`          // 手机号
	IsAdmin         int    `json:"is_admin"`                    // 用户类型
	OrgName         string `json:"org_name"`                    // 组织
}

type SystemUserBehaviorToEs struct {
	UserId          int    `json:"user_id"`                     // 系统用户id
	OrganizationId  string `json:"organization_id"`             // 组织uuid
	SystemModule    string `json:"system_module"`               // 系统模块
	OperateType     string `json:"operate_type"`                // 操作类型
	ReqMethod       int    `json:"req_method"`                  // 请求方式
	OperateStatus   int    `json:"operate_status"`              // 操作状态
	OperateIp       string `json:"operate_ip"`                  // 操作ip信息
	OperateAddr     string `json:"operate_addr"`                // 操作地点
	CreatedTime     string `json:"created_time" xorm:"created"` // 操作时间
	CreatedTimeUnix int64  `json:"created_time_unix"`           // 操作时间戳(用于排序统计)
	IsDeleted       int    `json:"is_deleted"`                  // 是否删除
	OperateMethod   string `json:"operate_method"`              // 操作方法函数名
	ResFields       string `json:"res_fields"`                  // 返回参数
	ReqParam        string `json:"req_param"`                   // 请求参数
	ReqUrl          string `json:"req_url"`                     // 请求地址
	AppId           string `json:"app_id"`                      // appId
	SystemAccount   string `json:"system_account"`              // 系统账号
	Phone           string `json:"phone" xorm:"phone"`          // 手机号
	//IsAdmin         int    `json:"is_admin"`                    // 用户类型
	OrgName string `json:"org_name"` // 组织
}

type SystemUserInfoEs struct {
	SystemAccount string `json:"system_account"` // 系统账号
	Phone         string `json:"-" xorm:"phone"` // 手机号
	//IsAdmin       int    `json:"is_admin"`       // 用户类型
	OrgName string `json:"org_name"` // 组织
}

type BehaviorEsListInfo struct {
	Total map[string]interface{} `json:"total"`
	Hits  []SourceData           `json:"hits"`
}

type SourceData struct {
	Id     string                 `json:"_id"`
	Source SystemUserBehaviorList `json:"_source"`
}

type SystemLogTree struct {
	Id    int    `json:"id"`
	Name  string `json:"name"`
	Value string `json:"value"`
}

type SystemLogEsListInfo struct {
	Hits []SystemLogSourceData `json:"hits"`
}

type SystemLogSourceData struct {
	Id     string          `json:"_id"`
	Source SystemLogEsList `json:"_source"`
}

type SystemLogEsList struct {
	Level     string `json:"level"`
	Timestamp string `json:"timestamp"`
	Msg       string `json:"msg"`
	Status    int    `json:"status"`
	Method    string `json:"method"`
	Path      string `json:"path"`
	Query     string `json:"query"`
	Ip        string `json:"ip"`
	UserAgent string `json:"user-agent"`
	Errors    string `json:"errors"`
	Cost      int    `json:"cost"`
	TimeUnit  int64  `json:"time_unit"`
}
