package response

import "time"

type TaskHistoryListRes struct {
	State         int       `json:"state"`              // 状态（0执行中 1成功 2失败）
	TaskId        int       `json:"task_id"`            // 任务id
	TaskName      string    `json:"task_name" `         // 任务名称
	ExecStartTime time.Time `json:"exec_start_time"`    // 执行开始时间
	ExecEndTime   time.Time `json:"exec_end_time"`      // 执行结束时间
	ExecTime      int       `json:"exec_time" xorm:"-"` // 执行耗时
	CreateUser    string    `json:"create_user" `       // 操作人
}

type TaskInfoListRes struct {
	Id            int       `json:"id"`                 // 主键id
	TaskId        int       `json:"task_id"`            // 任务id
	ExecStartTime time.Time `json:"exec_start_time" `   // 执行开始时间
	ExecEndTime   time.Time `json:"exec_end_time"`      // 执行结束时间
	ExecTime      int       `json:"exec_time" xorm:"-"` // 执行耗时
	CreateUser    string    `json:"create_user"`        // 操作人
	ExecDesc      string    `json:"exec_desc"`          // 执行说明
	State         int       `json:"state"`              // 状态（0执行中 1成功 2失败）
}

type TaskExecLogRes struct {
	Id            int       `json:"id"`                 // 主键id
	TaskId        int       `json:"task_id"`            // 任务id
	ExecDesc      string    `json:"exec_desc"`          // 执行说明
	TaskName      string    `json:"task_name"`          // 任务名称
	ExecStartTime time.Time `json:"exec_start_time" `   // 执行开始时间
	ExecEndTime   time.Time `json:"exec_end_time"`      // 执行结束时间
	ExecTime      int       `json:"exec_time" xorm:"-"` // 执行耗时
	State         int       `json:"state"`              // 状态（0执行中 1成功 2失败）
	ExecLog       string    `json:"exec_log"`           // 执行日志
}
