package controller

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

// AddMetricConfig 新增任务
func AddMetricConfig(c *gin.Context) {
	var req request.AddMetricConfig
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.MetricConfigSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	_, err = svc.Add(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func UpdateMetricConfig(c *gin.Context) {
	var req request.UpdateMetricConfig
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.MetricConfigSvc{User: header.GetUser(c)}
	db, err := client.GetDbClient()
	if err != nil {
		SendJsonResponse(c, resp.DbConnectError.WithError(err), nil)
		return
	}
	err = svc.Update(db.NewSession(), req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DeleteMetricConfig(c *gin.Context) {
	var req request.DeleteMetricConfig
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	var ids []string
	switch len(req.Ids) {
	case 0:
		ids = append(ids, req.Id)
	default:
		ids = req.Ids
	}

	svc := service.MetricConfigSvc{User: header.GetUser(c)}
	err := svc.Delete(ids)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func DetailMetricConfig(c *gin.Context) {
	var req request.DetailMetricConfig
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.MetricConfigSvc{User: header.GetUser(c)}
	data, err := svc.GetDataById(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func ListMetricConfig(c *gin.Context) {
	var req request.ListMetricConfig
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.MetricConfigSvc{User: header.GetUser(c)}
	data, err := svc.List(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}
