package controller

import (
	"errors"
	"github.com/gin-gonic/gin"
	"github.com/spf13/cast"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

// TaskHistoryList 任务历史列表
func TaskHistoryList(c *gin.Context) {
	var req request.TaskHistoryReq
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	taskHistorySvc := service.TaskHistorySvc{}
	total, list, err := taskHistorySvc.TaskHistoryList(req)
	if err != nil {
		SendJsonPageResponse(c, err, nil, 0)
		return
	}
	SendJsonPageResponse(c, resp.OK, list, total)
}

// TaskInfoList 任务历史详情列表
func TaskInfoList(c *gin.Context) {
	var req request.TaskInfoListReq
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	taskHistorySvc := service.TaskHistorySvc{}
	total, list, err := taskHistorySvc.TaskInfoList(req)
	if err != nil {
		SendJsonPageResponse(c, err, nil, 0)
		return
	}
	SendJsonPageResponse(c, resp.OK, list, total)
}

// TaskExecLog 任务执行日志
func TaskExecLog(c *gin.Context) {
	var (
		err error
		id  string
	)

	if id = c.Query("id"); id == "" {
		id = c.Param("id")
	}
	if id == "" {
		SendJsonResponse(c, resp.InvalidParam.WithError(errors.New("id为空")), nil)
		return
	}

	taskHistorySvc := service.TaskHistorySvc{}
	data, err := taskHistorySvc.TaskExecLog(cast.ToInt(id))
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}
