package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
)

// initDictRoute 初始化字典相关路由
func initDictRoute(e *gin.Engine) {
	base := e.Group(fmt.Sprintf("%s/dict", conf.Options.Prefix), header.SetContext)

	//系统字典
	dict := new(controller.Dict)
	base.POST("", dict.Add)                //新增字典
	base.PUT("", dict.Update)              //修改字典
	base.DELETE("", dict.Del)              //删除字典
	base.GET("", dict.List)                //字典列表
	base.GET("/tree", dict.DictTree)       //字典列表-树结构
	base.GET("/classList", dict.ClassList) //字典分类列表
	base.PUT("/sort", dict.DictSort)       //字典排序
	base.PUT("/status", dict.UpdateStatus) //字典排序

	//base.GET("/manage_list", dict.ManageList) //字典管理列表

}
