package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/constant"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
)

// 初始化访问控制管理路由
func InitAccessRuleRouter(e *gin.Engine) {
	rule := e.Group(fmt.Sprintf("%s/accessRule", conf.Options.Prefix), header.SetContext)
	{
		rule.POST("addAccessRule", controller.AddAccessRule, header.AddLogMiddleware("访问规则管理", "/addAccessRule", constant.OpTypeIntMap[constant.Add]))          // 新增访问规则
		rule.PUT("updateAccessRule", controller.UpdateAccessRule, header.AddLogMiddleware("访问规则管理", "/updateAccessRule", constant.OpTypeIntMap[constant.Edit])) // 编辑访问规则
		rule.DELETE("delAccessRule", controller.DelAccessRule, header.AddLogMiddleware("访问规则管理", "/delAccessRule", constant.OpTypeIntMap[constant.AllDelete]))  // 删除访问规则
		rule.GET("listAccessRule", controller.ListAccessRule, header.AddLogMiddleware("访问规则管理", "/listAccessRule", constant.OpTypeIntMap[constant.Find]))       // 查询访问规则列表
		rule.GET("listRuleUser", controller.ListRuleUser)                                                                                                       // 查询用户详情列表
		rule.PUT("updateState", controller.UpdateState)                                                                                                         // 修改规则状态
	}

}
