package router

import (
	"fmt"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"

	"github.com/gin-gonic/gin"
)

func InitSystemMenuRouter(e *gin.Engine) {
	base := e.Group(fmt.Sprintf("%s/menu", conf.Options.Prefix), header.SetContext)

	{
		base.GET("/group/dict", controller.GetGroupDict) //获取字典分组
		base.POST("/add", controller.AddSystemMenu)      //新增菜单
		base.PUT("/:id", controller.UpdateMenu)          //菜单更新
		base.GET("/tree", controller.GetMenuTree)        //获取菜单树形结构
		base.PUT("/sort", controller.MenuSort)           //菜单排序
		base.DELETE("/:id", controller.DeleteMenu)       //删除菜单
		base.GET("/user/tree", controller.GetSystemTree) //获取当前系统用户树
	}
}
