package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
)

// 初始化配置管理路由
func InitPreferenceConfigRouter(e *gin.Engine) {
	sys := e.Group(fmt.Sprintf("%s/sysOptions", conf.Options.Prefix), header.SetContext)
	{
		sys.GET("", controller.GetSystemOptions)                  // 获取系统首选项信息
		sys.POST("licenseOpts", controller.SetLicenseOptions)     // 设置授权信息
		sys.POST("loginPageOpts", controller.SetLoginPageOptions) // 设置授权信息
		sys.POST("safeOpts", controller.SetSafeOptions)           // 设置安全选项
		sys.POST("loginOpts", controller.SetLoginOptions)         // 设置登录选项
		sys.GET("checkLicense", controller.CheckLicense)          // 校验license是否有效
		sys.POST("reStartConfig", controller.ReStartConfig)       // 一键还原受限
		sys.POST("getLicenseInfo", controller.GetLicenseInfo)     // 获取license信息
	}
}
