package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
)

// InitWorkOrderRouter 初始化工单路由
func InitWorkOrderRouter(e *gin.Engine) {
	so := e.Group(fmt.Sprintf("%s/work_order", conf.Options.Prefix))
	//预警工单管理
	alert := so.Group("/alert")
	{
		alert.GET("", controller.DetailAlertList)    // 详情
		alert.GET("/list", controller.ListAlertList) // 列表
	}

	//业务工单管理
	manage := so.Group("/work_order_manage")
	{
		manage.POST("/add", controller.AddWorkOrderManage)        // 新增
		manage.PUT("/edit", controller.EditWorkOrderManage)       // 编辑
		manage.PUT("/state", controller.StateWorkOrderManage)     // 定时是否启用
		manage.DELETE("/del", controller.DelWorkOrderManage)      // 删除
		manage.GET("/details", controller.DetailsWorkOrderManage) // 详情
		manage.GET("/list", controller.ListWorkOrderManage)       // 列表
		manage.POST("/push", controller.PushWorkOrderManage)      // 手动下发
	}

	//业务工单列表
	list := so.Group("/work_order_issuance")
	{
		list.PUT("/close", controller.CloseWorkOrderIssuance)     // 关闭工单
		list.GET("/list", controller.ListWorkOrderIssuance)       // 业务工单下发列表
		list.GET("/details", controller.DetailsWorkOrderIssuance) // 业务工单下发详情
	}

	//我的业务工单
	me := so.Group("/work_order_me")
	{
		me.PUT("/feedback", controller.FeedbackWorkOrderMe) // 处置反馈
		me.GET("/list", controller.ListWorkOrderMe)         // 我的业务工单列表
	}
}
