package service

import (
	"github.com/google/uuid"
	"github.com/jinzhu/copier"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/response"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/util"
	"xorm.io/xorm"
)

type MetricConfigSvc struct {
	User entity.SystemUserInfo
}

func (m *MetricConfigSvc) Add(session *xorm.Session, req request.AddMetricConfig) (id string, err error) {
	now := jsontime.Now()
	data := entity.MetricConfig{
		Id:        uuid.New().String(),
		CreatedBy: m.User.SystemAccount,
		CreatedAt: now,
		UpdatedBy: m.User.SystemAccount,
		UpdatedAt: now,
	}
	_ = copier.Copy(&data, &req)
	data.AlertRange = util.ConvertToString(req.AlertRange)
	_, err = session.Insert(&data)
	if err != nil {
		return
	}
	id = data.Id
	return
}

func (m *MetricConfigSvc) Update(session *xorm.Session, req request.UpdateMetricConfig) error {
	now := jsontime.Now()
	data := entity.MetricConfig{
		UpdatedBy: m.User.SystemAccount,
		UpdatedAt: now,
	}
	_ = copier.Copy(&data, &req)
	data.AlertRange = util.ConvertToString(req.AlertRange)
	_, err := session.ID(req.Id).Update(&data)
	if err != nil {
		return err
	}
	return nil
}

func (m *MetricConfigSvc) GetDataById(req request.DetailMetricConfig) (resp response.MetricConfigItem, err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	_, err = db.NewSession().Table(resp.TableName()).Where("id = ?", req.Id).Get(&resp)
	return
}

func (m *MetricConfigSvc) List(req request.ListMetricConfig) (resp response.MetricConfigList, err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	session := db.NewSession()
	defer session.Close()
	if req.Id != "" {
		session.Where("id = ?", req.Id)
	}
	if req.ClassId != 0 {
		session.Where("class_id = ?", req.ClassId)
	}
	if req.MetricName != "" {
		session.Where("metric_name LIKE ?", "%"+req.MetricName+"%")
	}
	if req.IsEnabled != 0 {
		session.Where("is_enabled = ?", req.IsEnabled)
	}
	if req.StartTime != "" {
		session.Where("created_at >= ?", req.StartTime)
	}
	if req.EndTime != "" {
		session.Where("created_at <= ?", req.EndTime)
	}
	resp.TotalCount, err = session.Limit(req.GetPageSize(), (req.GetPage()-1)*req.GetPageSize()).
		OrderBy("id").FindAndCount(&resp.List)
	return
}

func (m *MetricConfigSvc) Delete(ids []string) (err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	_, err = db.NewSession().In("id", ids).Delete(new(entity.MetricConfig))
	return
}
