package entity

import "time"

type DictionaryBase struct {
	Id          string    `json:"id" xorm:"pk autoincr" `     //id
	Class       int       `json:"class"`                      //菜单分组id
	Name        string    `json:"name"  `                     //字典名称
	ParentId    int       `json:"parent_id"  `                //父级id
	Status      int32     `json:"status"  `                   //状态 1-启用 2-禁用
	IsDelete    int32     `json:"is_delete"  `                //是否删除 1-是 0-否
	DictType    int32     `json:"dict_type"  `                //字典类型（0-用户 1-系统）
	Description string    `json:"description"  `              //描述
	CreatedBy   int       `json:"created_by"  `               //创建者
	CreatedAt   time.Time `json:"created_at" xorm:"created" ` //创建时间
	UpdatedBy   int       `json:"updated_by"  `               //更新者
	UpdatedAt   time.Time `json:"updated_at" xorm:"updated" ` //更新时间
	Sort        int64     `json:"sort"  `                     //排序字段 降序排列
}
