package entity

import "gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"

type MetricConfig struct {
	Id            string        `json:"id" xorm:"'id' pk"`                        // 主键id
	ClassId       int           `json:"class_id" xorm:"'class_id'"`               // 预警对象分类id
	MetricName    string        `json:"metric_name" xorm:"'metric_name'"`         // 指标名称
	Expr          string        `json:"expr" xorm:"'expr'"`                       // 指标表达式(PromQL语句)
	AlertRange    string        `json:"alert_range" xorm:"'alert_range'"`         // 预警范围 字典值
	Duration      int           `json:"duration" xorm:"'duration'"`               // 持续时间
	DurationUnit  string        `json:"duration_unit" xorm:"'duration_unit'"`     // 持续时间单位 s m h
	CheckPeriod   int           `json:"check_period" xorm:"'check_period'"`       // 检查周期 单位:分钟
	IsEnabled     int           `json:"is_enabled" xorm:"'is_enabled'"`           // 是否开启 0:关闭 1:启动
	AlertRuleType string        `json:"alert_rule_type" xorm:"'alert_rule_type'"` // 预警规则类型 关联字典表
	CreatedBy     string        `json:"created_by" xorm:"'created_by'"`           // 创建人
	CreatedAt     jsontime.Time `json:"created_at" xorm:"'created_at'"`           // 创建时间
	UpdatedBy     string        `json:"updated_by" xorm:"'updated_by'"`           // 更新人
	UpdatedAt     jsontime.Time `json:"updated_at" xorm:"'updated_at'"`           // 更新时间
}

type AlertRange struct {
	VariableName string `json:"variable_name" binding:"required"`
	MetricName   string `json:"metric_name" binding:"required"`
	MetricLabel  string `json:"metric_label" binding:"required"`
	ChineseName  string `json:"chinese_name" binding:"required"`
	IsRequired   bool   `json:"is_required"`
	IsLinked     bool   `json:"is_linked"`
}

func (m *MetricConfig) TableName() string {
	return "metric_config"
}
