package entity

import (
	"time"
)

// SystemRole 系统角色
type SystemRole struct {
	Id          int64     `json:"id" xorm:"pk autoincr"`        // id
	RoleName    string    `json:"role_name"`                    // 角色名称
	RoleDesc    string    `json:"role_desc"`                    // 角色描述
	State       int       `json:"state"`                        // 状态0禁用1启用
	CreatedBy   int       `json:"created_by"`                   // 角色创建人
	CreatedTime time.Time `json:"created_time"`                 // 角色创建时间
	UpdatedTime time.Time `json:"updated_time"`                 // 角色更新时间
	UpdatedBy   int       `json:"updated_by"`                   // 角色更新人
	RoleType    int       `json:"role_type"`                    // 角色类型（0 普通角色 1 内置角色类型 不能删除和编辑 ）
	RoleId      string    `json:"role_id"`                      // 角色id（uuid）
	IsDeleted   int       `json:"is_deleted" xorm:"is_deleted"` // 是否删除
}
