package request

type AddAlertClass struct {
	ClassName string `json:"class_name" form:"class_name" binding:"required"`
	ParentId  int    `json:"parent_id" form:"parent_id" binding:"omitempty,oneof=0 1"`
	SortOrder int    `json:"sort_order" form:"sort_order"`
}

type UpdateAlertClass struct {
	ClassId   int    `json:"class_id" form:"class_id" binding:"required"`
	ClassName string `json:"class_name" form:"class_name" binding:"required"`
}

type DeleteAlertClass struct {
	ClassId  int   `json:"class_id" form:"class_id"`
	ClassIds []int `json:"class_ids" form:"class_ids" binding:"required_without=ClassId"`
}

type MoveAlertClass struct {
	ClassId   int    `json:"class_id" form:"class_id" binding:"required"`
	Direction string `json:"direction" form:"direction" binding:"oneof=up down"`
}

type DetailAlertClass struct {
	ClassId int `json:"class_id" form:"class_id" binding:"required"`
}

type ListAlertClass struct {
	ClassId   int    `json:"class_id" form:"class_id"`
	ClassName string `json:"class_name" form:"class_name"`
	Pagination
}
