package request

type AddHostManageReq struct {
	HostName    string `json:"host_name" binding:"required"` // 主机分组名称
	HostFileUrl string `json:"host_file_url"`                // 主机文件url
	Uuid        string `json:"uuid"`                         //临时缓存uuid
	//HostManageList []HostManageList `json:"host_manage_list"`             //主机列表
}

type HostManageList struct {
	Ip          string `json:"ip"`           // ip
	Port        string `json:"port"`         // 端口
	VoucherType int    `json:"voucher_type"` // 凭证类型（0密码验证 1密钥验证）
	UserName    string `json:"user_name"`    // 用户名
	Password    string `json:"password"`     // 密码
	IpGroup     int    `json:"ip_group"`     // ip分组
}

type EditHostManageReq struct {
	Id          int    `json:"id" binding:"required"` // 主键ID
	HostFileUrl string `json:"host_file_url"`         // 主机文件url
	Uuid        string `json:"uuid"`                  //临时缓存uuid
	//HostManageList []HostManageList `json:"host_manage_list"`      //主机列表
}

type DelHostManageReq struct {
	Id []int `json:"id" vd:"len($)>0;msg:'请输入id'"` // 主键ID
}

type ListHostManageReq struct {
	Search         string `json:"search" form:"search"`                     //关键词
	CreateDateFrom string `json:"create_date_from" form:"create_date_from"` //创建时间从
	CreateDateTo   string `json:"create_date_to" form:"create_date_to"`     //创建时间至
	Pagination
}

// StateHostManageReq 状态检测
type StateHostManageReq struct {
	DetectionType  int    `json:"detection_type" form:"detection_type" binding:"oneof=1 2 3"` //1主页列表手动检测 2输入ip列表保存时检测 3上传ip列表文件保存时检测
	Id             int    `json:"id" form:"id"`                                               //主机分组ID
	HostManageList string `json:"host_manage_list" form:"host_manage_list"`                   //主机ip列表
	FileName       string `json:"file_name" form:"file_name"`                                 //文件名称
}

// HostIpExceptionListReq 异常列表
type HostIpExceptionListReq struct {
	DetectionType int    `json:"detection_type" form:"detection_type" binding:"oneof=1 2"` //1主页异常ip列表 2保存检测时异常列表
	Id            int    `json:"id" form:"id"`                                             //主机分组ID
	Uuid          string `json:"uuid" form:"uuid"`                                         //临时缓存uuid
	Pagination
}
