package request

import "gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"

type AddMetricConfig struct {
	ClassId       int                 `json:"class_id" form:"class_id" binding:"required"`                       // 预警对象分类id
	MetricName    string              `json:"metric_name" form:"metric_name" binding:"required"`                 // 指标名称
	Expr          string              `json:"expr" form:"expr" binding:"required"`                               // 指标表达式(PromQL语句)
	AlertRange    []entity.AlertRange `json:"alert_range" form:"alert_range" binding:"required,dive"`            // 预警范围 字典值
	Duration      int                 `json:"duration" form:"duration"`                                          // 持续时间
	DurationUnit  string              `json:"duration_unit" form:"duration_unit" binding:"required,oneof=s m h"` // 持续时间单位 s m h
	CheckPeriod   int                 `json:"check_period" form:"check_period" binding:"oneof=1 3 5 10 20 30"`   // 检查周期 单位:分钟
	IsEnabled     int                 `json:"is_enabled" form:"is_enabled" binding:"oneof=0 1 2"`                // 是否开启 1:启动 2:停用
	AlertRuleType string              `json:"alert_rule_type" form:"alert_rule_type" binding:"required"`         // 预警规则类型 关联字典表
}

type UpdateMetricConfig struct {
	Id            string              `json:"id" form:"id" binding:"required"`                                           // 主键id
	ClassId       int                 `json:"class_id" form:"class_id"`                                                  // 预警对象分类id
	MetricName    string              `json:"metric_name" form:"metric_name"`                                            // 指标名称
	Expr          string              `json:"expr" form:"expr"`                                                          // 指标表达式(PromQL语句)
	AlertRange    []entity.AlertRange `json:"alert_range" form:"alert_range"`                                            // 预警范围 字典值
	Duration      int                 `json:"duration" form:"duration"`                                                  // 持续时间
	DurationUnit  string              `json:"duration_unit" form:"duration_unit" binding:"omitempty,oneof=s m h"`        // 持续时间单位 s m h
	CheckPeriod   int                 `json:"check_period" form:"check_period" binding:"omitempty,oneof=1 3 5 10 20 30"` // 检查周期 单位:分钟
	IsEnabled     int                 `json:"is_enabled" form:"is_enabled" binding:"omitempty,oneof=0 1 2"`              // 是否开启 1:启动 2:停用
	AlertRuleType string              `json:"alert_rule_type" form:"alert_rule_type"`                                    // 预警规则类型 关联字典表
}

type DeleteMetricConfig struct {
	Id  string   `json:"id" form:"id"`
	Ids []string `json:"ids" form:"ids" binding:"required_without=Id"`
}

type DetailMetricConfig struct {
	Id string `json:"id" form:"id" binding:"required"`
}

type ListMetricConfig struct {
	Id         string `json:"id" form:"id"`
	ClassId    int    `json:"class_id" form:"class_id"`
	MetricName string `json:"metric_name" form:"metric_name"`
	IsEnabled  int    `json:"is_enabled" form:"is_enabled" binding:"omitempty,oneof=0 1 2"`
	Pagination
}
