package request

// Pagination 分页
type Pagination struct {
	Page     int `json:"page" form:"page" binding:"omitempty"`
	PageSize int `json:"page_size" form:"page_size" binding:"omitempty"`
}

func (p Pagination) GetPage() int {
	if p.Page == 0 {
		p.Page = 1
	}
	return p.Page
}

func (p Pagination) GetPageSize() int {
	if p.PageSize == 0 {
		p.PageSize = 15
	}
	return p.PageSize
}
