package response

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
)

// 系统菜单表
type SystemMenuTree struct {
	Id          int32            `json:"id" xorm:"pk autoincr" `             //id
	Level       int              `json:"level" xorm:"level"`                 //菜单等级
	Sort        int              `json:"sort" xorm:"sort"`                   //菜单排序
	MenuName    string           `json:"menu_name" xorm:"menu_name"`         //菜单名称
	MenuType    int              `json:"menu_type" xorm:"menu_type"`         //菜单类型（0目录1菜单2子页面）
	DictGroupId string           `json:"dict_group_id" xorm:"dict_group_id"` //字典分组id
	State       int              `json:"state" xorm:"state"`                 //状态0禁用1启用
	MenuUrl     string           `json:"menu_url" xorm:"menu_url"`           //菜单路径
	MenuLogo    string           `json:"menu_logo" xorm:"menu_logo"`         //菜单图标
	CreatedTime jsontime.Time    `json:"created_time" xorm:"created"`        //创建时间
	UpdatedTime jsontime.Time    `json:"updated_time" xorm:"updated"`        //更新时间
	CreatedBy   string           `json:"created_by"`                         //创建者
	UpdatedBy   string           `json:"updated_by"`                         //更新者
	MenuId      string           `json:"menu_id" xorm:"menu_id"`             //菜单id
	PMenuId     string           `json:"p_menu_id" xorm:"p_menu_id"`         //上级菜单id
	Source      string           `json:"source" xorm:"source"`               //源
	Child       []SystemMenuTree `xorm:"-"`
}

// 系统菜单表
type SystemMenuTreePer struct {
	Id          int32               `json:"id" xorm:"pk autoincr" `             //id
	Level       int                 `json:"level" xorm:"level"`                 //菜单等级
	Sort        int                 `json:"sort" xorm:"sort"`                   //菜单排序
	MenuName    string              `json:"menuName" xorm:"menu_name"`          //菜单名称
	DictGroupId string              `json:"dict_group_id" xorm:"dict_group_id"` //字典分类id
	MenuType    int                 `json:"menuType" xorm:"menu_type"`          //菜单类型（0目录1菜单2子页面）
	Path        string              `json:"path" xorm:"menu_url"`               //菜单路径
	ParentPath  string              `json:"parentPath" xorm:"-"`
	Icon        string              `json:"icon" xorm:"menu_logo"`      //菜单图标
	MenuId      string              `json:"menu_id" xorm:"menu_id"`     //菜单id
	PMenuId     string              `json:"p_menu_id" xorm:"p_menu_id"` //上级菜单id
	Children    []SystemMenuTreePer `json:"children" xorm:"-"`
}
